using System;

namespace _8052Sim
{
	/// <summary>
	/// Interface.  IInstruction is a common interface for working with 8052 CPU Instructions.
	/// </summary>
	public interface IInstruction
	{
		/// <summary>
		/// Find the address if the user wants to "step-into"
		/// </summary>
		ushort AddressIntoInstruction(ushort address, byte b1, byte b2, byte b3);

		/// <summary>
		/// Find the address if the user wants to "step-over"
		/// </summary>
		ushort AddressOverInstruction(ushort address, byte b1, byte b2, byte b3);
		
		/// <summary>
		/// Returns TRUE if the series of bytes matches this instruction.
		/// </summary>
		bool Detect(byte b1, byte b2, byte b3);
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		void Execute(ushort address, byte b1, byte b2, byte b3);
		
		/// <summary>
		/// The number of CPU cycles this instruction requires.
		/// </summary>
		int ExecutionTimeInCycles
		{
			get;
		}

		/// <summary>
		/// The number of bytes this instruction occupies (1..3)
		/// </summary>
		ushort SizeInBytes
		{
			get;
		}
		
		/// <summary>
		/// Return this instruction, converted to string format.
		/// </summary>
		String ToString(ushort address, byte b1, byte b2, byte b3);
	}
}
