using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class AJmp : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public AJmp() 
			:	base(
			InstructionBase.InstructionType.IT_Jump,
			"AJMP <addr11>",	// name
			2,					// nBytes
			0x0100,				// value
			0x1f00,				// mask
			2)					// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Discovers the next address where the PC will be pointing after this 
		/// instruction is executed, assuming a branch occurs.
		/// </summary>
		public override ushort AddressIntoInstruction(ushort address, byte b1, byte b2, byte b3)
		{
			return (ushort)( (address & 0xf800) + ((ushort)(b1&0xe0)<<3) + b2);
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc += 2;
			Cpu8052.Pc = AddressIntoInstruction(address, b1, b2, b3);
		}
	}
}
