using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Add_ARn : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Add_ARn() 
			:	base(
			InstructionBase.InstructionType.IT_Arithmetic,
			"ADD A, Rn",	// name
			1,				// nBytes
			0x28,			// value
			0xf8,			// mask
			1)				// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.Acc = AddAndSetFlags(Cpu8052.Acc, Cpu8052.GetR(b1 & 0x07), false);
		}
	}
}
