using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Addc_ADirect : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Addc_ADirect() 
			:	base(
			InstructionBase.InstructionType.IT_Arithmetic,
			"ADDC A, <direct>",	// name
			2,					// nBytes
			0x3500,				// value
			0xff00,				// mask
			1)					// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.Acc = AddAndSetFlags(
				Cpu8052.Acc, 
				Cpu8052.GetDirect(b2), 
				Cpu8052.Psw_C
			);
		}
	}
}
