using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Cjne_RnDataRel : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Cjne_RnDataRel() 
			:	base(
			InstructionBase.InstructionType.IT_Jump,
			"CJNE <Rn>, #<data>, <rel>",	// name
			3,								// nBytes
			0xb80000,						// value
			0xf80000,						// mask
			2)								// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Discovers the next address where the PC will be pointing after this 
		/// instruction is executed, assuming a branch occurs.
		/// </summary>
		public override ushort AddressIntoInstruction(ushort address, byte b1, byte b2, byte b3)
		{
			if(b3>=0x80)	// 0x80..0xff
			{
				return (ushort)((int)(Cpu8052.Pc + 3)-(0x100-b3));
			}
			else	// 0x00..0x7f
			{
				return (ushort)((int)(Cpu8052.Pc + 3)+b3);
			}
		}

		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			if(Cpu8052.GetR(b1 & 0x07) != b2)
				Cpu8052.Pc = AddressIntoInstruction(address, b1, b2, b3);
			else
				Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.Psw_C = (Cpu8052.GetR(b1 & 0x07) < b2);
		}
	}
}
