using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Da_A : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Da_A() 
			:	base(
			InstructionBase.InstructionType.IT_Logic,
			"DA A",	// name
			1,			// nBytes
			0xd4,		// value
			0xff,		// mask
			1)			// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// NOTE: This instruction is implemented in contradition with the DA A 
		/// instruction docs in the 8051 datasheet.  The Datasheet states that 
		/// the AC flag, not the C flag, should be tested for the lower 4 bits.
		/// However, that leads to incorrect behaviour, it appears, so I 
		/// implemented it this way, which was documented online and appears to 
		/// work correctly.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			if( ((Cpu8052.Acc & 0x0f) > 9) || Cpu8052.Psw_C )
			{
				Cpu8052.Psw_C = true;
				Cpu8052.Acc += 0x06;
			}
			else
			{
				Cpu8052.Psw_C = false;
			}
			
			if( (Cpu8052.Acc > 0x9f) || Cpu8052.Psw_C )
			{
				Cpu8052.Psw_C = true;
				Cpu8052.Acc += 0x60;
			}
			else
			{
				Cpu8052.Psw_C = false;
			}
		}
	}
}
