using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Dec_Rn : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Dec_Rn() 
		:	base(
			InstructionBase.InstructionType.IT_Arithmetic,
			"DEC <Rn>",	// name
			1,			// nBytes
			0x18,		// value
			0xf8,		// mask
			1)			// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.SetR(b1 & 0x07, (byte)(Cpu8052.GetR(b1 & 0x07)-1));
		}
	}
}
