using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Div_AB : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Div_AB() 
			:	base(
			InstructionBase.InstructionType.IT_Arithmetic,
			"DIV AB",	// name
			1,			// nBytes
			0x84,		// value
			0xff,		// mask
			4)			// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			int result = (int)((int)Cpu8052.Acc / (int)Cpu8052.B);
			int remainder = (int)((int)Cpu8052.Acc % (int)Cpu8052.B);
			Cpu8052.Acc = (byte)(result & 0xff);
			Cpu8052.B = (byte)(remainder & 0xff);
			Cpu8052.Psw_Ov = false;
			Cpu8052.Psw_C = false;
		}
	}
}
