using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Djnz_DirectRel : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Djnz_DirectRel() 
			:	base(
			InstructionBase.InstructionType.IT_Jump,
			"DJNZ <direct>, <rel>",	// name
			3,						// nBytes
			0xd50000,				// value
			0xff0000,				// mask
			2)						// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Discovers the next address where the PC will be pointing after this 
		/// instruction is executed, assuming a branch occurs.
		/// </summary>
		public override ushort AddressIntoInstruction(ushort address, byte b1, byte b2, byte b3)
		{
			if(b3>=0x80)	// 0x80..0xff
			{
				return (ushort)((int)(Cpu8052.Pc + 3)-(0x100-b3));
			}
			else	// 0x00..0x7f
			{
				return (ushort)((int)(Cpu8052.Pc + 3)+b3);
			}
		}

		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			byte val = (byte)(Cpu8052.GetDirect(b2)-1);
			Cpu8052.SetDirect(
				b2,
				val
			);
			
			if( val != 0)
				Cpu8052.Pc = AddressIntoInstruction(address, b1, b2, b3);
			else
				Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
		}
	}
}
