using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Djnz_RnRel : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Djnz_RnRel() 
			:	base(
			InstructionBase.InstructionType.IT_Jump,
			"DJNZ <Rn>, <rel>",	// name
			2,					// nBytes
			0xd800,				// value
			0xf800,				// mask
			2)					// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Discovers the next address where the PC will be pointing after this 
		/// instruction is executed, assuming a branch occurs.
		/// </summary>
		public override ushort AddressIntoInstruction(ushort address, byte b1, byte b2, byte b3)
		{
			if(b2>=0x80)	// 0x80..0xff
			{
				return (ushort)((int)(Cpu8052.Pc + 2)-(0x100-b2));
			}
			else	// 0x00..0x7f
			{
				return (ushort)((int)(Cpu8052.Pc + 2)+b2);
			}
		}

		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.SetR(
				b1 & 0x07, 
				(byte)(Cpu8052.GetR(
					b1 & 0x07
				)-1)
			);
			
			if( Cpu8052.GetR(b1&0x07) != 0)
				Cpu8052.Pc = AddressIntoInstruction(address, b1, b2, b3);
			else
				Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
		}
	}
}
