using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Jmp_atAplusDptr : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Jmp_atAplusDptr() 
			:	base(
			InstructionBase.InstructionType.IT_Jump,
			"JMP @A+DPTR",	// name
			1,				// nBytes
			0x73,			// value
			0xff,			// mask
			2)				// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = (ushort)(Cpu8052.Dptr + Cpu8052.Acc);
		}
	}
}
