using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class LJmp : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public LJmp() 
		:	base(
			InstructionBase.InstructionType.IT_Jump,
			"LJMP <addr>",	// name
			3,				// nBytes
			0x020000,		// value
			0xff0000,		// mask
			2)				// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Discovers the next address where the PC will be pointing after this 
		/// instruction is executed, assuming a branch occurs.
		/// </summary>
		public override ushort AddressIntoInstruction(ushort address, byte b1, byte b2, byte b3)
		{
			return (ushort)(((ushort)b2<<8)+b3);
		}

		/// <summary>
		/// Discovers the next address where the PC will be pointing after this 
		/// instruction is executed, assuming no branh occurs.
		/// </summary>
		public override ushort AddressOverInstruction(ushort address, byte b1, byte b2, byte b3)
		{
			return AddressIntoInstruction(address, b1, b2, b3);
		}

		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressIntoInstruction(address, b1, b2, b3);
		}
	}
}
