using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Mov_DirectData : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Mov_DirectData() 
		:	base(
			InstructionBase.InstructionType.IT_DataMove,
			"MOV <Direct>, #<data>",	// name
			3,							// nBytes
			0x750000,					// value
			0xff0000,					// mask
			2)							// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.SetDirect(b2, b3);
		}
	}
}
