using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Mov_RnData : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Mov_RnData() 
			:	base(
			InstructionBase.InstructionType.IT_DataMove,
			"MOV <Rn>, #<data>",	// name
			2,						// nBytes
			0x7800,					// value
			0xf800,					// mask
			1)						// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.SetR(b1&0x07, b2);
		}
	}
}
