using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Movc_AatAplusPc : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Movc_AatAplusPc() 
			:	base(
			InstructionBase.InstructionType.IT_DataMove,
			"MOVC A, @A+PC",	// name
			1,					// nBytes
			0x83,				// value
			0xff,				// mask
			2)					// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.Acc = Flash.GetByte(
				(ushort)(Cpu8052.Acc+Cpu8052.Pc), 
				Flash.A16
			);
		}
	}
}
