using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Movx_atRiA : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Movx_atRiA() 
			:	base(
			InstructionBase.InstructionType.IT_DataMove,
			"MOVX @Ri, A",		// name
			1,					// nBytes
			0xf2,				// value
			0xfe,				// mask
			2)					// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			XRam.WriteByte(
				Cpu8052.GetR(b1 & 0x01), 
				Cpu8052.Acc
			);
		}
	}
}
