using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Mul_AB : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Mul_AB() 
			:	base(
			InstructionBase.InstructionType.IT_Arithmetic,
			"MUL AB",	// name
			1,			// nBytes
			0xa4,		// value
			0xff,		// mask
			4)			// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			int result = (int)((int)Cpu8052.Acc * (int)Cpu8052.B);
			Cpu8052.Acc = (byte)(result & 0xff);
			Cpu8052.B = (byte)(result >> 8);
			Cpu8052.Psw_Ov = (result > 0x00ff);
			Cpu8052.Psw_C = false;
		}
	}
}
