using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Orl_AatRi : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Orl_AatRi() 
			:	base(
			InstructionBase.InstructionType.IT_Boolean,
			"ORL A, @Ri",	// name
			1,				// nBytes
			0x46,			// value
			0xfe,			// mask
			1)				// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.Acc |= Cpu8052.GetIndirect(Cpu8052.GetR(b1 & 0x01));
		}
	}
}
