using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Push_Direct : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Push_Direct() 
			:	base(
			InstructionBase.InstructionType.IT_DataMove,
			"PUSH <Direct>",	// name
			2,					// nBytes
			0xc000,				// value
			0xff00,				// mask
			2)					// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.PushStack(
				Cpu8052.GetDirect(b2)
			);
		}
	}
}
