using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Ret : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Ret() 
			:	base(
			InstructionBase.InstructionType.IT_Logic,
			"RET",		// name
			1,			// nBytes
			0x22,		// value
			0xff,		// mask
			1)			// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Discovers the next address where the PC will be pointing after this 
		/// instruction is executed, assuming no branh occurs.
		/// </summary>
		public override ushort AddressOverInstruction(ushort address, byte b1, byte b2, byte b3)
		{
			return (ushort)(((ushort)Cpu8052.Stack(0)*256)+Cpu8052.Stack(-1));
		}

		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.PopStack();
			Cpu8052.PopStack();
		}
	}
}
