using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Rl_A : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Rl_A() 
		:	base(
			InstructionBase.InstructionType.IT_Boolean,
			"RL A",		// name
			1,			// nBytes
			0x23,		// value
			0xff,		// mask
			1)			// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			int a = Cpu8052.Acc;
			Cpu8052.Acc = (byte)((((a & 0x80) != 0) ? 0x01 : 0x00) + a * 2);
		}
	}
}
