using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Setb_C : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Setb_C() 
			:	base(
			InstructionBase.InstructionType.IT_Logic,
			"SETB C",	// name
			1,				// nBytes
			0xd3,			// value
			0xff,			// mask
			1)				// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.Psw_C = true;
		}
	}
}
