using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Xrl_ARn : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Xrl_ARn() 
			:	base(
			InstructionBase.InstructionType.IT_Logic,
			"XRL A, Rn",		// name
			1,					// nBytes
			0x68,				// value
			0xf8,				// mask
			1)					// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.Acc ^= Cpu8052.GetR(b1 & 0x07);
		}
	}
}
