using System;

namespace _8052Sim.Instruction
{
	/// <summary>
	/// This object knows how to execute and interpret an 8052 Instruction.
	/// </summary>
	public class Xrl_DirectA : InstructionBase
	{
		/// <summary>
		/// Create a new Instruction object.
		/// </summary>
		public Xrl_DirectA() 
			:	base(
			InstructionBase.InstructionType.IT_Logic,
			"XRL <direct>, A",	// name
			2,					// nBytes
			0x6200,				// value
			0xff00,				// mask
			1)					// cycles
		{
			// nothing to do...
		}
		
		/// <summary>
		/// Performs the actions on the CPU which implement this instruction.
		/// </summary>
		public override void Execute(ushort address, byte b1, byte b2, byte b3)
		{
			Cpu8052.Pc = AddressOverInstruction(address, b1, b2, b3);
			Cpu8052.SetDirect(
				b2, 
				(byte)(Cpu8052.GetDirect(b2) ^ Cpu8052.Acc)
				);
		}
	}
}
