using System;

namespace _8052Sim
{
	/// <summary>
	/// Static object.  The InstructionInterpreter can figure out what instruction a bunch of bytes are.
	/// </summary>
	public class InstructionInterpreter
	{
		/// <summary>
		/// Constructor, creates one of each kind of instruction.
		/// </summary>
		static InstructionInterpreter()
		{
			Add(new Instruction.ACall());
			Add(new Instruction.Add_AData());
			Add(new Instruction.Add_ADirect());
			Add(new Instruction.Add_ARn());
			Add(new Instruction.Addc_AData());
			Add(new Instruction.Addc_ADirect());
			Add(new Instruction.Addc_ARn());
			Add(new Instruction.AJmp());
			Add(new Instruction.Anl_AData());
			Add(new Instruction.Anl_ADirect());
			Add(new Instruction.Anl_ARn());
			Add(new Instruction.Anl_DirectA());
			Add(new Instruction.Anl_DirectData());
			Add(new Instruction.Cjne_ADataRel());
			Add(new Instruction.Cjne_RnDataRel());
			Add(new Instruction.Cjne_ADirectRel());
			Add(new Instruction.Clr_A());
			Add(new Instruction.Clr_Bit());
			Add(new Instruction.Clr_C());
			Add(new Instruction.Cpl_A());
			Add(new Instruction.Cpl_Bit());
			Add(new Instruction.Da_A());
			Add(new Instruction.Dec_A());
			Add(new Instruction.Dec_Direct());
			Add(new Instruction.Dec_Rn());
			Add(new Instruction.Div_AB());
			Add(new Instruction.Djnz_DirectRel());
			Add(new Instruction.Djnz_RnRel());
			Add(new Instruction.Inc_A());
			Add(new Instruction.Inc_Direct());
			Add(new Instruction.Inc_Dptr());
			Add(new Instruction.Inc_Rn());
			Add(new Instruction.Jb_BitRel());
			Add(new Instruction.Jc_Rel());
			Add(new Instruction.Jmp_atAplusDptr());
			Add(new Instruction.Jnb_BitRel());
			Add(new Instruction.Jnc_Rel());
			Add(new Instruction.Jnz_Rel());
			Add(new Instruction.Jz_Rel());
			Add(new Instruction.LCall());
			Add(new Instruction.LJmp());
			Add(new Instruction.Mov_AatRi());
			Add(new Instruction.Mov_AData());
			Add(new Instruction.Mov_ADirect());
			Add(new Instruction.Mov_ARn());
			Add(new Instruction.Mov_atRiA());
			Add(new Instruction.Mov_atRiData());
			Add(new Instruction.Mov_atRiDirect());
			Add(new Instruction.Mov_BitC());
			Add(new Instruction.Mov_CBit());
			Add(new Instruction.Mov_DirectA());
			Add(new Instruction.Mov_DirectAtRi());
			Add(new Instruction.Mov_DirectData());
			Add(new Instruction.Mov_DirectDirect());
			Add(new Instruction.Mov_DirectRn());
			Add(new Instruction.Mov_DptrData16());
			Add(new Instruction.Mov_RnA());
			Add(new Instruction.Mov_RnData());
			Add(new Instruction.Mov_RnDirect());
			Add(new Instruction.Movc_AatAplusDptr());
			Add(new Instruction.Movc_AatAplusPc());
			Add(new Instruction.Movx_AatDptr());
			Add(new Instruction.Movx_AatRi());
			Add(new Instruction.Movx_atDptrA());
			Add(new Instruction.Movx_atRiA());
			Add(new Instruction.Mul_AB());
			Add(new Instruction.Nop());
			Add(new Instruction.Orl_AData());
			Add(new Instruction.Orl_AatRi());
			Add(new Instruction.Orl_ARn());
			Add(new Instruction.Orl_DirectA());
			Add(new Instruction.Orl_DirectData());
			Add(new Instruction.Pop_Direct());
			Add(new Instruction.Push_Direct());
			Add(new Instruction.Ret());
			Add(new Instruction.Reti());
			Add(new Instruction.Rl_A());
			Add(new Instruction.Rlc_A());
			Add(new Instruction.Rr_A());
			Add(new Instruction.Rrc_A());
			Add(new Instruction.Setb_Bit());
			Add(new Instruction.Setb_C());
			Add(new Instruction.SJmp());
			Add(new Instruction.Subb_AData());
			Add(new Instruction.Subb_ADirect());
			Add(new Instruction.Subb_ARn());
			Add(new Instruction.Swap_A());
			Add(new Instruction.Xch_ADirect());
			Add(new Instruction.Xch_ARn());
			Add(new Instruction.Xrl_AData());
			Add(new Instruction.Xrl_ARn());
			Add(new Instruction.Xrl_DirectA());
			Add(new Instruction.Xrl_DirectData());
		}
		

		/// <summary>
		/// Add an instruction to the list of known instructions.
		/// In the future, they may be stored in a complex tree or some other way.
		/// </summary>
		private static void Add(IInstruction i)
		{
			for(int n=0;n<instructions.Length;n++)
			{
				if(i.Detect((byte)n,(byte)0,(byte)0))
				{
					System.Diagnostics.Debug.Assert(instructions[n] == null, "Instruction Mask Conflict!");
					instructions[n] = i;
				}
			}
		}
		

		/// <summary>
		/// Examines a few bytes of code, and decides what kind of instruction is being executed.
		/// </summary>
		public static IInstruction FigureInstruction(byte b1, byte b2, byte b3)
		{
			if(instructions[b1] != null)
				return instructions[b1];
			MainForm.SourceViewJumpToPC();	// show the bad line...
			System.Diagnostics.Debug.Assert(false, "Please implement this unimplemented instruction!");
			return null;
		}

		private static IInstruction[] instructions = new IInstruction[256];
	}
}
