using System;

namespace _8052Sim
{
	/// <summary>
	/// This represents a Breakpoint, as created by the user or a step command.
	/// </summary>
	public class Breakpoint
	{
		/// <summary>
		/// The kind eof breakpoint this is.
		/// </summary>
		public enum BreakpointType
		{
			BT_Flash,
//			BT_XData,
//			BT_Data
		}

		/// <summary>
		/// Create a new breakpoint at a specific code address.
		/// </summary>
		public Breakpoint(int _address)	// 0x00000..0x1ffff
		{
			address = _address;
		}
		
		/// <summary>
		/// Remove all references to this breakpoint, and then allow it to be gc'd.
		/// </summary>
		public void DestroyBreakpoint()
		{
//			Flash.DestroyBreakpoint(this);
		}
		
		/// <summary>
		/// TRUE if the breakpoint is active, FALSE if it is disabled.
		/// </summary>
		private bool isActive = true;

		/// <summary>
		/// TRUE if the breakpoint is active, FALSE if it is disabled.
		/// </summary>
		public bool IsActive
		{
			get	{	return isActive;	}
			set	{	isActive = value;	}
		}
		
		/// <summary>
		/// The address in CODE memory which this breakpoint is associated with.
		/// </summary>
		private int address;

		/// <summary>
		/// The address which this breakpoint is associated with.
		/// </summary>
		public int Address
		{
			get	{	return address;	}
		}
	}
}
