using System;

namespace _8052Sim
{
	/// <summary>
	/// Static object.  BreakpointManager is the common interface for creating new breakpoints.
	/// </summary>
	public class BreakpointManager
	{
		/// <summary>
		/// Create a new breakpoint in flash memory.
		/// If deleteOnBreak is TRUE, the breakpoint will self-kill as soon as the simulation finds any reason to stop.
		/// </summary>
		public static Breakpoint AddFlashBreakpoint(int addr)	// 0x00000..0x1ffff
		{
			System.Diagnostics.Debug.Assert((addr>=0) && (addr<=0x1ffff));
			Breakpoint b = new Breakpoint(addr);
			Flash.AddBreakpoint(b);
			allFlashBreakpoints.Add(b);
			return b;
		}
		
		/// <summary>
		/// Returns TRUE if at-least one breakpoint exists at the specified address.
		/// </summary>
		public static bool BreakpointExistsAt(int addr)
		{
			System.Diagnostics.Debug.Assert((addr>=0) && (addr<=0x1ffff));
			return (Flash.BreakpointAt(addr) != null);
		}
		
		/// <summary>
		/// Remove all breakpoints from memory which are assoicated with this address.
		/// </summary>
		public static void RemoveBreakpoint(int addr)
		{
			System.Diagnostics.Debug.Assert((addr>=0) && (addr<=0x1ffff));
			for(int n=0;n<allFlashBreakpoints.Count;n++)
			{
				if(((Breakpoint)allFlashBreakpoints[n]).Address == addr)
				{
					Breakpoint b = (Breakpoint)allFlashBreakpoints[n];
					Flash.DestroyBreakpoint(b);
					b.DestroyBreakpoint();
					allFlashBreakpoints.RemoveAt(n);

					// go back and re-evaluate the same index again, 
					// since we just removed what was just there and 
					// everything beyond shifted back by one.
					n--;
					continue;
				}
			}
		}
		
		/// <summary>
		/// Keeps a collection of all created breakpoints, active and inactive.
		/// </summary>
		private static System.Collections.ArrayList allFlashBreakpoints = new System.Collections.ArrayList();	// Breakpoint objects
	}
}
