using System;

namespace _8052Sim
{
	/// <summary>
	/// CommandFifo is an object which queue's commands from the user interface to the simulation.
	/// </summary>
	public class CommandFifo
	{
		/// <summary>
		/// The commands which are currently queue'd.  the first one is the next command to execute.
		/// </summary>
		static private System.Collections.ArrayList commandFifo = new System.Collections.ArrayList(); // CommandInterface objects
		
		/// <summary>
		/// Used to syncronize access to this obkect.
		/// </summary>
		private static int syncRoot = 0;
		
		/// <summary>
		/// Constructor
		/// </summary>
		public CommandFifo()
		{
		}
		
		/// <summary>
		/// Issue the command
		/// </summary>
		public static void StepInto()
		{
			Push(new CommandStepInto());
		}

		/// <summary>
		/// Issue the command
		/// </summary>
		public static void StepOver()
		{
			Push(new CommandStepOver());
		}

		/// <summary>
		/// Issue the command
		/// </summary>
		public static void StepOut()
		{
			Push(new CommandStepOut());
		}

		/// <summary>
		/// Issue the command
		/// </summary>
		public static void Run()
		{
			Push(new CommandRun());
		}

		/// <summary>
		/// Issue the command
		/// </summary>
		public static void Restart()
		{
			Push(new CommandRestart());
		}

		/// <summary>
		/// Issue the command
		/// </summary>
		public static void Break()
		{
			Push(new CommandBreak());
		}
		
		/// <summary>
		/// Push the command onto the end of the command-fifo.
		/// </summary>
		private static void Push(CommandInterface i)
		{
			Lock();
			
			commandFifo.Add(i);
			
			Unlock();
		}

		/// <summary>
		/// Fetch the next command which needs to be performed.
		/// </summary>
		public static CommandInterface GetNextCommand()
		{
			Lock();
			
			CommandInterface i = null;
			if(commandFifo.Count != 0)
			{
				i = (CommandInterface)commandFifo[0];
				commandFifo.RemoveAt(0);
			}
			
			Unlock();
			
			return i;
		}

		/// <summary>
		/// acquire an exclusive lock on the internal values of this object.
		/// </summary>
		private static void Lock()
		{
			while(System.Threading.Interlocked.Increment(ref syncRoot) != 1)
			{
				System.Threading.Interlocked.Decrement(ref syncRoot);
				System.Threading.Thread.Sleep(100);
			}
		}

		/// <summary>
		/// release the lock.
		/// </summary>
		private static void Unlock()
		{
			System.Threading.Interlocked.Decrement(ref syncRoot);
		}
	}
}
