using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for DramMemoryForm.
	/// </summary>
	public class DRamMemoryForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ListBox pageView;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox pageToDisplay;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DRamMemoryForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private void DramMemoryForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel = true;	// don't let it get closed!
			MainForm.ToggleDRamMemoryMenuItem.Checked = !MainForm.ToggleDRamMemoryMenuItem.Checked;
			Visible = MainForm.ToggleDRamMemoryMenuItem.Checked;
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.pageView = new System.Windows.Forms.ListBox();
			this.label1 = new System.Windows.Forms.Label();
			this.pageToDisplay = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// pageView
			// 
			this.pageView.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.pageView.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.pageView.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageView.HorizontalScrollbar = true;
			this.pageView.ItemHeight = 14;
			this.pageView.Location = new System.Drawing.Point(8, 32);
			this.pageView.Name = "pageView";
			this.pageView.Size = new System.Drawing.Size(528, 182);
			this.pageView.TabIndex = 0;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 8);
			this.label1.Name = "label1";
			this.label1.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
			this.label1.Size = new System.Drawing.Size(72, 16);
			this.label1.TabIndex = 1;
			this.label1.Text = "DRAM Page";
			// 
			// pageToDisplay
			// 
			this.pageToDisplay.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageToDisplay.Location = new System.Drawing.Point(96, 8);
			this.pageToDisplay.MaxLength = 4;
			this.pageToDisplay.Name = "pageToDisplay";
			this.pageToDisplay.Size = new System.Drawing.Size(40, 20);
			this.pageToDisplay.TabIndex = 2;
			this.pageToDisplay.Text = "0000";
			this.pageToDisplay.WordWrap = false;
			this.pageToDisplay.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.dramPageToDisplay_KeyPressed);
			this.pageToDisplay.TextChanged += new System.EventHandler(this.dramPageToDisplay_TextChanged);
			// 
			// DRamMemoryForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(544, 224);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.pageToDisplay,
																		  this.label1,
																		  this.pageView});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.Name = "DRamMemoryForm";
			this.Text = "DRAM Page";
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.DramMemoryForm_Closing);
			this.Load += new System.EventHandler(this.DramMemoryForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		// captures the state of internal ram in the CPU, on the screen.
		public void CaptureState()
		{
			if(pageView.Items.Count == 0)
				return;
				
			ushort page = ushort.Parse(
				"0"+pageToDisplay.Text, 
				System.Globalization.NumberStyles.HexNumber
				);
			
			pageView.BeginUpdate();
			for(ushort i=0;i<4096;i+=16)
			{
				String line = i.ToString("X4") + ": ";
				for(ushort n=0;n<16;n++)
				{
					line += Xilinx.ReadDram8(page, (ushort)(i+n)).ToString("X2");
					if(n == 7)
						line += "  ";
					else
						line += " ";
				}
				line += " ";
				for(ushort n=0;n<16;n++)
				{
					byte c = Xilinx.ReadDram8(page, (ushort)(i+n));
					if( (c >= 32) && (c <= 127) )
						line += Char.ToString((char)c);
					else
						line += ".";
				}	
				pageView.Items[i/16] = line;
			}
			pageView.EndUpdate();
		}

		private void DramMemoryForm_Load(object sender, System.EventArgs e)
		{
			pageView.Items.Clear();
			for(int i=0;i<4096;i+=16)
				pageView.Items.Add("");
			CaptureState();
		}

		private void dramPageToDisplay_TextChanged(object sender, System.EventArgs e)
		{
			ushort page = (ushort)MainForm.TextToValue(16, pageToDisplay.Text);
			CaptureState();
		}

		private void dramPageToDisplay_KeyPressed(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if(Char.IsDigit(e.KeyChar))
			{
				// handle the character...
				e.Handled = false;
			}
			else if(
				( Char.ToUpper(e.KeyChar) >= Char.Parse("A") ) &&
				( Char.ToUpper(e.KeyChar) <= Char.Parse("F") )
				)
			{
				// handle the character...
				e.Handled = false;
			}
			else if(e.KeyChar == 0x8)	// backspace
			{
				// handle the character...
				e.Handled = false;
			}
			else
			{
				e.Handled = true;	// ignore the character
			}
		}
	}
}
