using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for ExternalMemoryForm.
	/// </summary>
	public class ExternalMemoryForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ListBox xramView;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ComboBox pageToDisplay;
		private System.Windows.Forms.Label currentPageLabel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ExternalMemoryForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private void ExternalMemoryForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel = true;	// don't let it get closed!
			MainForm.ToggleExternalMemoryMenuItem.Checked = !MainForm.ToggleExternalMemoryMenuItem.Checked;
			Visible = MainForm.ToggleExternalMemoryMenuItem.Checked;
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.xramView = new System.Windows.Forms.ListBox();
			this.label1 = new System.Windows.Forms.Label();
			this.pageToDisplay = new System.Windows.Forms.ComboBox();
			this.currentPageLabel = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// xramView
			// 
			this.xramView.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.xramView.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.xramView.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.xramView.HorizontalScrollbar = true;
			this.xramView.ItemHeight = 14;
			this.xramView.Location = new System.Drawing.Point(8, 32);
			this.xramView.Name = "xramView";
			this.xramView.Size = new System.Drawing.Size(528, 182);
			this.xramView.TabIndex = 0;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 8);
			this.label1.Name = "label1";
			this.label1.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
			this.label1.Size = new System.Drawing.Size(72, 16);
			this.label1.TabIndex = 1;
			this.label1.Text = "XRAM Page";
			// 
			// pageToDisplay
			// 
			this.pageToDisplay.Items.AddRange(new object[] {
															   "0xxx - (Global Variables)",
															   "1xxx - (Global Variables)",
															   "2xxx - STA013 Buffer 1/2",
															   "3xxx - STA013 Buffer 2/2",
															   "4xxx - Free Memory List Current Page",
															   "5xxx - IDE Target For Reads",
															   "6xxx - PageStack Current Page",
															   "7xxx - ",
															   "8xxx - ",
															   "9xxx - ",
															   "Axxx - ",
															   "Bxxx - ",
															   "Cxxx - ",
															   "Dxxx - ",
															   "Exxx - Task\'s \"This\" Page"});
			this.pageToDisplay.Location = new System.Drawing.Point(96, 8);
			this.pageToDisplay.MaxDropDownItems = 16;
			this.pageToDisplay.Name = "pageToDisplay";
			this.pageToDisplay.Size = new System.Drawing.Size(200, 21);
			this.pageToDisplay.TabIndex = 2;
			this.pageToDisplay.Text = "0xxx (Global Variables)";
			this.pageToDisplay.SelectedIndexChanged += new System.EventHandler(this.pageToDisplay_SelectedIndexChanged);
			// 
			// currentPageLabel
			// 
			this.currentPageLabel.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.currentPageLabel.Location = new System.Drawing.Point(304, 8);
			this.currentPageLabel.Name = "currentPageLabel";
			this.currentPageLabel.Size = new System.Drawing.Size(136, 16);
			this.currentPageLabel.TabIndex = 3;
			this.currentPageLabel.Text = "= XXXX";
			// 
			// ExternalMemoryForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(544, 224);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.currentPageLabel,
																		  this.pageToDisplay,
																		  this.label1,
																		  this.xramView});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.Name = "ExternalMemoryForm";
			this.Text = "XRAM Page";
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.ExternalMemoryForm_Closing);
			this.Load += new System.EventHandler(this.ExternalMemoryForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		// captures the state of internal ram in the CPU, on the screen.
		public void CaptureState()
		{
			if(pageToDisplay.SelectedIndex < 0)
				pageToDisplay.SelectedIndex = 0;
				
			ushort page = (ushort)(pageToDisplay.SelectedIndex);
			
			xramView.BeginUpdate();
			if(!Xilinx.IsLegalPage((ushort)(page<<12)))
			{
				// bad page!
				currentPageLabel.Text = "= (not mapped)";
				for(ushort i=0;i<4096;i+=16)
					xramView.Items[i/16] = "";
				xramView.Items[0] = "(this page is not mapped within DRAM yet)";
			}
			else
			{
				// good page!
				int thePage = Xilinx.PeepDramPageNumber(page);
				currentPageLabel.Text = "= "+thePage.ToString("X4");
				for(ushort i=0;i<4096;i+=16)
				{
					int address = i + page * 0x1000;
					String line = i.ToString("X4") + ": ";
					for(ushort n=0;n<16;n++)
					{
						line += XRam.ReadByte((ushort)(address+n)).ToString("X2");
						if(n == 7)
							line += "  ";
						else
							line += " ";
					}
					line += " ";
					for(ushort n=0;n<16;n++)
					{
						byte c = XRam.ReadByte((ushort)(address+n));
						if( (c >= 32) && (c <= 127) )
							line += Char.ToString((char)c);
						else
							line += ".";
					}	
					xramView.Items[i/16] = line;
				}
			}
			xramView.EndUpdate();
		}

		private void ExternalMemoryForm_Load(object sender, System.EventArgs e)
		{
			xramView.Items.Clear();
			for(int i=0;i<4096;i+=16)
				xramView.Items.Add("");
			CaptureState();
		}

		private void dramPageToDisplay_KeyPressed(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if(Char.IsDigit(e.KeyChar))
			{
				// handle the character...
				e.Handled = false;
			}
			else if(
				( Char.ToUpper(e.KeyChar) >= Char.Parse("A") ) &&
				( Char.ToUpper(e.KeyChar) <= Char.Parse("F") )
			)
			{
				// handle the character...
				e.Handled = false;
			}
			else if(e.KeyChar == 0x8)	// backspace
			{
				// handle the character...
				e.Handled = false;
			}
			else
			{
				e.Handled = true;	// ignore the character
			}
		}

		private void pageToDisplay_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			CaptureState();
		}
	}
}
