using System;

namespace _8052Sim
{
	/// <summary>
	/// FileCache is a storage area for text files which we want to be able to
	/// reference quickly, for tasks such as displaying in the source-window.
	/// </summary>
	public class FileCache
	{
		/// <summary>
		/// Retrieve a cached file from the FileCache.
		/// If the file was not cached already, it is cached now.
		/// </summary>
		public static String[] File(String filename)
		{
			return TheCachedFile(filename).Lines;
		}
		
		public static CachedFile TheCachedFile(String filename)
		{
			// search through the existing items in the cache for the desired item
			for(int n=0;n<files.Count;n++)
				if(((CachedFile)files[n]).Compare(filename))
				{
					CachedFile theCachedFile = (CachedFile)files[n];
					
					// move the file to the top of the list.
					if(n != 0)
					{
						files.RemoveAt(n);
						files.Insert(0, theCachedFile);
					}

					return theCachedFile;
				}

			// load the file and add it to the cache.
			CachedFile newFile = new CachedFile(filename);
			files.Insert(0,newFile);
			return newFile;
		}
		
		/// <summary>
		/// A collection of all the files which have already been cached.
		/// </summary>
		private static System.Collections.ArrayList files = new System.Collections.ArrayList();	// array of CachedFile's
	}
}
