using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for FileTreeBrowserForm.
	/// </summary>
	public class FileTreeBrowserForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.Label label19;
		private System.Windows.Forms.Label label20;
		private System.Windows.Forms.GroupBox groupBox4;
		private System.Windows.Forms.TextBox fileNodeIndex;
		private System.Windows.Forms.TextBox fileNodePage;
		private System.Windows.Forms.Button viewPrevSibblingFile;
		private System.Windows.Forms.Button viewNextSibblingFile;
		private System.Windows.Forms.Button viewFileName;
		private System.Windows.Forms.TextBox nameNodeOffset;
		private System.Windows.Forms.TextBox nameNodePage;
		private System.Windows.Forms.ListBox stackView;
		private System.Windows.Forms.Button stackPop;
		private System.Windows.Forms.Button visitRootFolder;
		private System.Windows.Forms.Label txtPrevSibblingFile;
		private System.Windows.Forms.Label txtNextSibblingFile;
		private System.Windows.Forms.Label txtFileSize;
		private System.Windows.Forms.Label txtFileName;
		private System.Windows.Forms.Label txtClusterNumber;
		private System.Windows.Forms.Label txtNameNodeText;
		private System.Windows.Forms.Button stackPush;
		private System.Windows.Forms.Button viewParentName;
		private System.Windows.Forms.Label txtParentName;
		private System.Windows.Forms.GroupBox groupFileNode;
		private System.Windows.Forms.GroupBox groupNameNode;
		private System.Windows.Forms.Button viewLastFilePrevFolder;
		private System.Windows.Forms.Label txtLastFilePrevFolder;
		private System.Windows.Forms.Button viewFirstFileNextFolder;
		private System.Windows.Forms.Label txtFirstFileNextFolder;
		
		
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public FileTreeBrowserForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private void FileTreeBrowserForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel = true;	// don't let it get closed!
			MainForm.ToggleFileTreeBrowserMenuItem.Checked = !MainForm.ToggleFileTreeBrowserMenuItem.Checked;
			Visible = MainForm.ToggleFileTreeBrowserMenuItem.Checked;
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupFileNode = new System.Windows.Forms.GroupBox();
			this.viewPrevSibblingFile = new System.Windows.Forms.Button();
			this.txtPrevSibblingFile = new System.Windows.Forms.Label();
			this.viewNextSibblingFile = new System.Windows.Forms.Button();
			this.txtNextSibblingFile = new System.Windows.Forms.Label();
			this.txtFileSize = new System.Windows.Forms.Label();
			this.viewFileName = new System.Windows.Forms.Button();
			this.txtFileName = new System.Windows.Forms.Label();
			this.txtClusterNumber = new System.Windows.Forms.Label();
			this.fileNodeIndex = new System.Windows.Forms.TextBox();
			this.label11 = new System.Windows.Forms.Label();
			this.label12 = new System.Windows.Forms.Label();
			this.fileNodePage = new System.Windows.Forms.TextBox();
			this.groupNameNode = new System.Windows.Forms.GroupBox();
			this.viewParentName = new System.Windows.Forms.Button();
			this.txtParentName = new System.Windows.Forms.Label();
			this.txtNameNodeText = new System.Windows.Forms.Label();
			this.nameNodeOffset = new System.Windows.Forms.TextBox();
			this.label19 = new System.Windows.Forms.Label();
			this.label20 = new System.Windows.Forms.Label();
			this.nameNodePage = new System.Windows.Forms.TextBox();
			this.groupBox4 = new System.Windows.Forms.GroupBox();
			this.stackPush = new System.Windows.Forms.Button();
			this.stackPop = new System.Windows.Forms.Button();
			this.stackView = new System.Windows.Forms.ListBox();
			this.visitRootFolder = new System.Windows.Forms.Button();
			this.viewLastFilePrevFolder = new System.Windows.Forms.Button();
			this.txtLastFilePrevFolder = new System.Windows.Forms.Label();
			this.viewFirstFileNextFolder = new System.Windows.Forms.Button();
			this.txtFirstFileNextFolder = new System.Windows.Forms.Label();
			this.groupFileNode.SuspendLayout();
			this.groupNameNode.SuspendLayout();
			this.groupBox4.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupFileNode
			// 
			this.groupFileNode.Controls.AddRange(new System.Windows.Forms.Control[] {
																						this.viewLastFilePrevFolder,
																						this.txtLastFilePrevFolder,
																						this.viewFirstFileNextFolder,
																						this.txtFirstFileNextFolder,
																						this.viewPrevSibblingFile,
																						this.txtPrevSibblingFile,
																						this.viewNextSibblingFile,
																						this.txtNextSibblingFile,
																						this.txtFileSize,
																						this.viewFileName,
																						this.txtFileName,
																						this.txtClusterNumber,
																						this.fileNodeIndex,
																						this.label11,
																						this.label12,
																						this.fileNodePage});
			this.groupFileNode.Location = new System.Drawing.Point(8, 56);
			this.groupFileNode.Name = "groupFileNode";
			this.groupFileNode.Size = new System.Drawing.Size(456, 216);
			this.groupFileNode.TabIndex = 1;
			this.groupFileNode.TabStop = false;
			this.groupFileNode.Text = "FileNode";
			// 
			// viewPrevSibblingFile
			// 
			this.viewPrevSibblingFile.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.viewPrevSibblingFile.Location = new System.Drawing.Point(8, 192);
			this.viewPrevSibblingFile.Name = "viewPrevSibblingFile";
			this.viewPrevSibblingFile.Size = new System.Drawing.Size(32, 16);
			this.viewPrevSibblingFile.TabIndex = 27;
			this.viewPrevSibblingFile.Text = "GO";
			this.viewPrevSibblingFile.Click += new System.EventHandler(this.viewPrevSibblingFile_Click);
			// 
			// txtPrevSibblingFile
			// 
			this.txtPrevSibblingFile.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtPrevSibblingFile.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtPrevSibblingFile.Location = new System.Drawing.Point(48, 192);
			this.txtPrevSibblingFile.Name = "txtPrevSibblingFile";
			this.txtPrevSibblingFile.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtPrevSibblingFile.Size = new System.Drawing.Size(400, 16);
			this.txtPrevSibblingFile.TabIndex = 26;
			this.txtPrevSibblingFile.Text = "Prev Sibbling File";
			this.txtPrevSibblingFile.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// viewNextSibblingFile
			// 
			this.viewNextSibblingFile.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.viewNextSibblingFile.Location = new System.Drawing.Point(8, 168);
			this.viewNextSibblingFile.Name = "viewNextSibblingFile";
			this.viewNextSibblingFile.Size = new System.Drawing.Size(32, 16);
			this.viewNextSibblingFile.TabIndex = 25;
			this.viewNextSibblingFile.Text = "GO";
			this.viewNextSibblingFile.Click += new System.EventHandler(this.viewNextSibblingFile_Click);
			// 
			// txtNextSibblingFile
			// 
			this.txtNextSibblingFile.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtNextSibblingFile.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtNextSibblingFile.Location = new System.Drawing.Point(48, 168);
			this.txtNextSibblingFile.Name = "txtNextSibblingFile";
			this.txtNextSibblingFile.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtNextSibblingFile.Size = new System.Drawing.Size(400, 16);
			this.txtNextSibblingFile.TabIndex = 24;
			this.txtNextSibblingFile.Text = "Next Sibbling File = (0000/0)";
			this.txtNextSibblingFile.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// txtFileSize
			// 
			this.txtFileSize.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtFileSize.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFileSize.Location = new System.Drawing.Point(256, 96);
			this.txtFileSize.Name = "txtFileSize";
			this.txtFileSize.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtFileSize.Size = new System.Drawing.Size(192, 16);
			this.txtFileSize.TabIndex = 20;
			this.txtFileSize.Text = "File Size";
			this.txtFileSize.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// viewFileName
			// 
			this.viewFileName.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.viewFileName.Location = new System.Drawing.Point(8, 48);
			this.viewFileName.Name = "viewFileName";
			this.viewFileName.Size = new System.Drawing.Size(32, 40);
			this.viewFileName.TabIndex = 19;
			this.viewFileName.Text = "GO";
			this.viewFileName.Click += new System.EventHandler(this.viewFileName_Click);
			// 
			// txtFileName
			// 
			this.txtFileName.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtFileName.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFileName.Location = new System.Drawing.Point(48, 48);
			this.txtFileName.Name = "txtFileName";
			this.txtFileName.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtFileName.Size = new System.Drawing.Size(400, 40);
			this.txtFileName.TabIndex = 18;
			this.txtFileName.Text = "File Name";
			this.txtFileName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtClusterNumber
			// 
			this.txtClusterNumber.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtClusterNumber.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtClusterNumber.Location = new System.Drawing.Point(48, 96);
			this.txtClusterNumber.Name = "txtClusterNumber";
			this.txtClusterNumber.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtClusterNumber.Size = new System.Drawing.Size(192, 16);
			this.txtClusterNumber.TabIndex = 16;
			this.txtClusterNumber.Text = "Cluster Number";
			this.txtClusterNumber.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// fileNodeIndex
			// 
			this.fileNodeIndex.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.fileNodeIndex.Location = new System.Drawing.Point(160, 16);
			this.fileNodeIndex.Name = "fileNodeIndex";
			this.fileNodeIndex.Size = new System.Drawing.Size(40, 20);
			this.fileNodeIndex.TabIndex = 7;
			this.fileNodeIndex.Text = "0";
			this.fileNodeIndex.TextChanged += new System.EventHandler(this.fileNodeIndex_TextChanged);
			// 
			// label11
			// 
			this.label11.Location = new System.Drawing.Point(112, 16);
			this.label11.Name = "label11";
			this.label11.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
			this.label11.Size = new System.Drawing.Size(40, 16);
			this.label11.TabIndex = 6;
			this.label11.Text = "Index";
			this.label11.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// label12
			// 
			this.label12.Location = new System.Drawing.Point(8, 16);
			this.label12.Name = "label12";
			this.label12.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
			this.label12.Size = new System.Drawing.Size(32, 16);
			this.label12.TabIndex = 5;
			this.label12.Text = "Page";
			this.label12.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// fileNodePage
			// 
			this.fileNodePage.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.fileNodePage.Location = new System.Drawing.Point(48, 16);
			this.fileNodePage.Name = "fileNodePage";
			this.fileNodePage.Size = new System.Drawing.Size(40, 20);
			this.fileNodePage.TabIndex = 4;
			this.fileNodePage.Text = "0000";
			this.fileNodePage.TextChanged += new System.EventHandler(this.fileNodePage_TextChanged);
			// 
			// groupNameNode
			// 
			this.groupNameNode.Controls.AddRange(new System.Windows.Forms.Control[] {
																						this.viewParentName,
																						this.txtParentName,
																						this.txtNameNodeText,
																						this.nameNodeOffset,
																						this.label19,
																						this.label20,
																						this.nameNodePage});
			this.groupNameNode.Location = new System.Drawing.Point(8, 280);
			this.groupNameNode.Name = "groupNameNode";
			this.groupNameNode.Size = new System.Drawing.Size(456, 72);
			this.groupNameNode.TabIndex = 2;
			this.groupNameNode.TabStop = false;
			this.groupNameNode.Text = "NameNode";
			// 
			// viewParentName
			// 
			this.viewParentName.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.viewParentName.Location = new System.Drawing.Point(248, 16);
			this.viewParentName.Name = "viewParentName";
			this.viewParentName.Size = new System.Drawing.Size(32, 16);
			this.viewParentName.TabIndex = 25;
			this.viewParentName.Text = "GO";
			this.viewParentName.Click += new System.EventHandler(this.viewParentName_Click);
			// 
			// txtParentName
			// 
			this.txtParentName.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtParentName.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtParentName.Location = new System.Drawing.Point(288, 16);
			this.txtParentName.Name = "txtParentName";
			this.txtParentName.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtParentName.Size = new System.Drawing.Size(160, 16);
			this.txtParentName.TabIndex = 24;
			this.txtParentName.Text = "Parent Folder";
			this.txtParentName.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// txtNameNodeText
			// 
			this.txtNameNodeText.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtNameNodeText.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtNameNodeText.Location = new System.Drawing.Point(8, 48);
			this.txtNameNodeText.Name = "txtNameNodeText";
			this.txtNameNodeText.Size = new System.Drawing.Size(440, 16);
			this.txtNameNodeText.TabIndex = 8;
			this.txtNameNodeText.Text = "Text = []";
			// 
			// nameNodeOffset
			// 
			this.nameNodeOffset.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.nameNodeOffset.Location = new System.Drawing.Point(160, 16);
			this.nameNodeOffset.Name = "nameNodeOffset";
			this.nameNodeOffset.Size = new System.Drawing.Size(40, 20);
			this.nameNodeOffset.TabIndex = 7;
			this.nameNodeOffset.Text = "0";
			this.nameNodeOffset.TextChanged += new System.EventHandler(this.nameNodeOffset_TextChanged);
			// 
			// label19
			// 
			this.label19.Location = new System.Drawing.Point(112, 16);
			this.label19.Name = "label19";
			this.label19.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
			this.label19.Size = new System.Drawing.Size(40, 16);
			this.label19.TabIndex = 6;
			this.label19.Text = "Offset";
			this.label19.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// label20
			// 
			this.label20.Location = new System.Drawing.Point(8, 16);
			this.label20.Name = "label20";
			this.label20.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
			this.label20.Size = new System.Drawing.Size(32, 16);
			this.label20.TabIndex = 5;
			this.label20.Text = "Page";
			this.label20.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// nameNodePage
			// 
			this.nameNodePage.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.nameNodePage.Location = new System.Drawing.Point(48, 16);
			this.nameNodePage.Name = "nameNodePage";
			this.nameNodePage.Size = new System.Drawing.Size(40, 20);
			this.nameNodePage.TabIndex = 4;
			this.nameNodePage.Text = "0000";
			this.nameNodePage.TextChanged += new System.EventHandler(this.nameNodePage_TextChanged);
			// 
			// groupBox4
			// 
			this.groupBox4.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.stackPush,
																					this.stackPop,
																					this.stackView});
			this.groupBox4.Location = new System.Drawing.Point(8, 360);
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.Size = new System.Drawing.Size(456, 168);
			this.groupBox4.TabIndex = 3;
			this.groupBox4.TabStop = false;
			this.groupBox4.Text = "Stack";
			// 
			// stackPush
			// 
			this.stackPush.Location = new System.Drawing.Point(8, 16);
			this.stackPush.Name = "stackPush";
			this.stackPush.Size = new System.Drawing.Size(40, 64);
			this.stackPush.TabIndex = 2;
			this.stackPush.Text = "Push";
			this.stackPush.Click += new System.EventHandler(this.stackPush_Click);
			// 
			// stackPop
			// 
			this.stackPop.Location = new System.Drawing.Point(8, 96);
			this.stackPop.Name = "stackPop";
			this.stackPop.Size = new System.Drawing.Size(40, 64);
			this.stackPop.TabIndex = 1;
			this.stackPop.Text = "Pop";
			this.stackPop.Click += new System.EventHandler(this.stackPop_Click);
			// 
			// stackView
			// 
			this.stackView.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.stackView.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.stackView.ItemHeight = 14;
			this.stackView.Items.AddRange(new object[] {
														   "0000/0 (FolderNode)"});
			this.stackView.Location = new System.Drawing.Point(56, 16);
			this.stackView.Name = "stackView";
			this.stackView.Size = new System.Drawing.Size(392, 144);
			this.stackView.TabIndex = 0;
			// 
			// visitRootFolder
			// 
			this.visitRootFolder.Location = new System.Drawing.Point(8, 16);
			this.visitRootFolder.Name = "visitRootFolder";
			this.visitRootFolder.Size = new System.Drawing.Size(216, 32);
			this.visitRootFolder.TabIndex = 4;
			this.visitRootFolder.Text = "Return to Root Folder";
			this.visitRootFolder.Click += new System.EventHandler(this.visitRootFolder_Click);
			// 
			// viewLastFilePrevFolder
			// 
			this.viewLastFilePrevFolder.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.viewLastFilePrevFolder.Location = new System.Drawing.Point(8, 144);
			this.viewLastFilePrevFolder.Name = "viewLastFilePrevFolder";
			this.viewLastFilePrevFolder.Size = new System.Drawing.Size(32, 16);
			this.viewLastFilePrevFolder.TabIndex = 31;
			this.viewLastFilePrevFolder.Text = "GO";
			this.viewLastFilePrevFolder.Click += new System.EventHandler(this.viewLastFilePrevFolder_Click);
			// 
			// txtLastFilePrevFolder
			// 
			this.txtLastFilePrevFolder.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtLastFilePrevFolder.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtLastFilePrevFolder.Location = new System.Drawing.Point(48, 144);
			this.txtLastFilePrevFolder.Name = "txtLastFilePrevFolder";
			this.txtLastFilePrevFolder.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtLastFilePrevFolder.Size = new System.Drawing.Size(400, 16);
			this.txtLastFilePrevFolder.TabIndex = 30;
			this.txtLastFilePrevFolder.Text = "Last File Of Prev Folder";
			this.txtLastFilePrevFolder.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// viewFirstFileNextFolder
			// 
			this.viewFirstFileNextFolder.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.viewFirstFileNextFolder.Location = new System.Drawing.Point(8, 120);
			this.viewFirstFileNextFolder.Name = "viewFirstFileNextFolder";
			this.viewFirstFileNextFolder.Size = new System.Drawing.Size(32, 16);
			this.viewFirstFileNextFolder.TabIndex = 29;
			this.viewFirstFileNextFolder.Text = "GO";
			this.viewFirstFileNextFolder.Click += new System.EventHandler(this.viewFirstFileNextFolder_Click);
			// 
			// txtFirstFileNextFolder
			// 
			this.txtFirstFileNextFolder.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtFirstFileNextFolder.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFirstFileNextFolder.Location = new System.Drawing.Point(48, 120);
			this.txtFirstFileNextFolder.Name = "txtFirstFileNextFolder";
			this.txtFirstFileNextFolder.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtFirstFileNextFolder.Size = new System.Drawing.Size(400, 16);
			this.txtFirstFileNextFolder.TabIndex = 28;
			this.txtFirstFileNextFolder.Text = "First File Of Next Folder = (0000/0)";
			this.txtFirstFileNextFolder.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// FileTreeBrowserForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(472, 536);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.visitRootFolder,
																		  this.groupBox4,
																		  this.groupNameNode,
																		  this.groupFileNode});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.Name = "FileTreeBrowserForm";
			this.Text = "FileTree Browser";
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FileTreeBrowserForm_Closing);
			this.Load += new System.EventHandler(this.FileTreeBrowserForm_Load);
			this.groupFileNode.ResumeLayout(false);
			this.groupNameNode.ResumeLayout(false);
			this.groupBox4.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void FileTreeBrowserForm_Load(object sender, System.EventArgs e)
		{
			ViewRootFolder();
		}

		private void visitRootFolder_Click(object sender, System.EventArgs e)
		{
			ViewRootFolder();
		}
		
		private void ViewRootFolder()
		{
			ulong rootFile = MainForm.globalVariablesForm.GetRootFolder();
			CurrentNodeType = NodeType.FileNode;
			currentNodePage = (ushort)(rootFile & 0xffff);
			currentNodeIndexOffset = (ushort)((rootFile>>16) & 0xffff);
			Push();
		}
	
		private void Push()
		{
			nodeTypeStack.Add(CurrentNodeType);
			nodePageStack.Add(currentNodePage);
			nodeIndexOffsetStack.Add(currentNodeIndexOffset);
			CaptureState();
		}
		
		private void Pop()
		{
			if(nodeTypeStack.Count > 1)
			{
				nodeTypeStack.RemoveAt(nodeTypeStack.Count-1);
				nodePageStack.RemoveAt(nodePageStack.Count-1);
				nodeIndexOffsetStack.RemoveAt(nodeIndexOffsetStack.Count-1);

				CurrentNodeType = (NodeType)nodeTypeStack[nodeTypeStack.Count-1];
				currentNodePage = (ushort)nodePageStack[nodePageStack.Count-1];
				currentNodeIndexOffset = (ushort)nodeIndexOffsetStack[nodeIndexOffsetStack.Count-1];
			}
			CaptureState();
		}
		
		/// <summary>
		/// Get a 4-byte value from the specified DRAM page & offset
		/// </summary>
		ulong GetLong(ushort dramPage, ushort offset)
		{
			PageOfDram pageOfDram = Dram.GetPageNumber(dramPage);
			if(pageOfDram == null)
				return 0;
			if( (offset >= 0 ) && (offset <= 4096-4) )
				return pageOfDram.Read32(offset);
			return 0;
		}
		
		/// <summary>
		/// Get a 2-byte value from the specified DRAM page & offset
		/// </summary>
		ushort GetWord(ushort dramPage, ushort offset)
		{
			PageOfDram pageOfDram = Dram.GetPageNumber(dramPage);
			if(pageOfDram == null)
				return 0;
			if( (offset >= 0 ) && (offset <= 4096-2) )
				return pageOfDram.Read16(offset);
			return 0;
		}
		
		/// <summary>
		/// Get a byte value from the specified DRAM page & offset
		/// </summary>
		ushort GetByte(ushort dramPage, ushort offset)
		{
			PageOfDram pageOfDram = Dram.GetPageNumber(dramPage);
			if(pageOfDram == null)
				return 0;
			if( (offset >= 0 ) && (offset < 4096) )
				return pageOfDram.Read8(offset);
			return 0;
		}
		
		/// <summary>
		/// Fetch the string which resides at this NameNode
		/// </summary>
		String GetNameNodeString(ushort page, ushort offset)
		{
			if( (page == 0) && (offset == 0) )
				return "<NO_NAME_NODE>";	// empty string!
			
			String str = "";
			int max = 255;
			offset += 4;	// skip the pointer to parent NameNode
			do
			{
				char c = (char)GetByte(page, offset++);
				if(c == 0)
					return str;
				str += c;
				max--;
				if( (max == 0) || (offset == 4096) )
				{
					str = "<BAD>";
					return str;
				}
			}
			while(true);
		}
		
		private void CaptureStack()
		{
//			stackView;
			int selection = stackView.SelectedIndex;
			int top = stackView.TopIndex;
			
			stackView.BeginUpdate();
			stackView.Items.Clear();
			for(int n=0;n<nodePageStack.Count;n++)
			{
				String kind = "";
				switch((NodeType)nodeTypeStack[n])
				{
					case NodeType.FileNode:		kind = "FileNode";		break;
					case NodeType.NameNode:		kind = "NameNode";		break;

					default:
						System.Diagnostics.Debug.Assert(false);
						break;
				}
				
				String str = 
					((ushort)nodePageStack[n]).ToString("X4") +
					"/" +
					((ushort)nodeIndexOffsetStack[n]).ToString() +
					" " +
					kind;
					
				if((NodeType)nodeTypeStack[n] == NodeType.NameNode)
				{
					str += 
						" = " +
						GetNameNodeString((ushort)nodePageStack[n],(ushort)nodeIndexOffsetStack[n]);
				}
				
				stackView.Items.Add(str);
			}
			stackView.EndUpdate();

			if(top + (stackView.Height / stackView.ItemHeight) >= stackView.Items.Count)
				top = stackView.Items.Count - (stackView.Height / stackView.ItemHeight);
			if(top < 0)
				top = 0;
//			if(top > 0)
//				top--;

			if(selection >= stackView.Items.Count)
				selection = stackView.Items.Count-1;
			if(selection < 0)
				selection = 0;

			stackView.SelectedIndex = selection;
			stackView.TopIndex = top;
		}
		
		public void CaptureState()
		{
			switch(CurrentNodeType)
			{
				case NodeType.FileNode:		CaptureFile();		break;
				case NodeType.NameNode:		CaptureName();		break;
			
				default:
					System.Diagnostics.Debug.Assert(false);
					break;
			}
			CaptureStack();
		}
		
		
		private void CaptureFile()
		{
			if( (currentNodePage != 0) || (currentNodeIndexOffset != 0) )
			{
				ushort page = currentNodePage;
				ushort index = currentNodeIndexOffset;
				
				// Page
				fileNodePage.Text = page.ToString("X4");
				
				// Index
				fileNodeIndex.Text = index.ToString();

				if(index < 4096/(int)FileNodeStruct.SizeOf)	// if the entry is legal...
				{
					// Cluster Number
					ulong theClusterNumber = GetLong(page, (ushort)((int)FileNodeStruct.FirstClusterNumber + index * (int)FileNodeStruct.SizeOf));
					txtClusterNumber.Text = 
						"Cluster Number = " + 
						((ulong)theClusterNumber).ToString("X8");
						
					// File Name
					ushort thePage	 = GetWord(page, (ushort)((int)FileNodeStruct.FileName + 0 + index * (int)FileNodeStruct.SizeOf));
					ushort theOffset = GetWord(page, (ushort)((int)FileNodeStruct.FileName + 2 + index * (int)FileNodeStruct.SizeOf));
					ushort theIndex;
					txtFileName.Text = 
						"File Name = (" + 
						thePage.ToString("X4") + 
						"/" + 
						theOffset.ToString() +
						") = " +
						GetNameNodeString(thePage, theOffset);

					// File Size
					ulong theFileSize = GetLong(page, (ushort)((int)FileNodeStruct.SizeInBytes + index * (int)FileNodeStruct.SizeOf));
					txtFileSize.Text = 
						"File Size = " + 
						((ulong)theFileSize).ToString("X8");
						
					// Next Sibbling File
					thePage	 = GetWord(page, (ushort)((int)FileNodeStruct.NextSibblingFile + 0 + index * (int)FileNodeStruct.SizeOf));
					theIndex = GetWord(page, (ushort)((int)FileNodeStruct.NextSibblingFile + 2 + index * (int)FileNodeStruct.SizeOf));
					txtNextSibblingFile.Text = 
						"Next Sibbling File = (" + 
						thePage.ToString("X4") + 
						"/" + 
						theIndex.ToString() +
						")";
						
					// Prev Sibbling File
					thePage	 = GetWord(page, (ushort)((int)FileNodeStruct.PrevSibblingFile + 0 + index * (int)FileNodeStruct.SizeOf));
					theIndex = GetWord(page, (ushort)((int)FileNodeStruct.PrevSibblingFile + 2 + index * (int)FileNodeStruct.SizeOf));
					txtPrevSibblingFile.Text = 
						"Prev Sibbling File = (" + 
						thePage.ToString("X4") + 
						"/" + 
						theIndex.ToString() +
						")";
					
					// Next Folder First File
					thePage	 = GetWord(page, (ushort)((int)FileNodeStruct.FirstFileOfNextFolder + 0 + index * (int)FileNodeStruct.SizeOf));
					theIndex = GetWord(page, (ushort)((int)FileNodeStruct.FirstFileOfNextFolder + 2 + index * (int)FileNodeStruct.SizeOf));
					txtFirstFileNextFolder.Text = 
						"First File Of Next Folder = (" + 
						thePage.ToString("X4") + 
						"/" + 
						theIndex.ToString() +
						")";
						
					// Prev Folder Last File
					thePage	 = GetWord(page, (ushort)((int)FileNodeStruct.LastFileOfPrevFolder + 0 + index * (int)FileNodeStruct.SizeOf));
					theIndex = GetWord(page, (ushort)((int)FileNodeStruct.LastFileOfPrevFolder + 2 + index * (int)FileNodeStruct.SizeOf));
					txtLastFilePrevFolder.Text = 
						"Last File Of Prev Folder = (" + 
						thePage.ToString("X4") + 
						"/" + 
						theIndex.ToString() +
						")";
					
					return;
				}
			}
			
			// TODO - Render (illegal) node!
		}
		
		
		private void CaptureName()
		{
			if( (currentNodePage != 0) || (currentNodeIndexOffset != 0) )
			{
				ushort page = currentNodePage;
				ushort offset = currentNodeIndexOffset;
				
				// Page
				nameNodePage.Text = page.ToString("X4");
				
				// Index
				nameNodeOffset.Text = offset.ToString();

				if(offset < 4096-4)	// if the entry is legal...
				{
					// Parent Name
					ushort thePage	 = GetWord(page, (ushort)((int)NameNodeStruct.ParentName + 0 + offset));
					ushort theOffset = GetWord(page, (ushort)((int)NameNodeStruct.ParentName + 2 + offset));
					txtParentName.Text = 
						"Parent Name = (" + 
						thePage.ToString("X4") + 
						"/" + 
						theOffset.ToString() +
						") = "
						/* + GetNameNodeString(thePage, theOffset)	*/
						;

					// NAME
					txtNameNodeText.Text = 
						"TEXT = [" + GetNameNodeString(page, offset) + "]";
					
					return;
				}
			}
			
			// TODO - Render (illegal) node!
		}
		
		
		enum FileNodeStruct
		{	// field			// offset in structure
			FirstClusterNumber		= 0*4,
			FileName				= 1*4,
			SizeInBytes				= 2*4,
			NextSibblingFile		= 3*4,
			PrevSibblingFile		= 4*4,
			FirstFileOfNextFolder	= 5*4,
			LastFileOfPrevFolder	= 6*4,
			//	<not used>			= 7*4,
			// -----------------------
			SizeOf					= 8*4,
		};
		
		enum NameNodeStruct
		{	// field			// offset in structure
			ParentName	= 0*4,
		};
		
		enum NodeType
		{
			FileNode,
			NameNode,
		};
		
		/// <summary>
		/// The stack of node types (File/Name)
		/// </summary>
		System.Collections.ArrayList nodeTypeStack = new System.Collections.ArrayList();	// NodeType's

		/// <summary>
		/// The type of the current node (File/Name)
		/// </summary>
		private NodeType _currentNodeType = NodeType.FileNode;
		private NodeType CurrentNodeType
		{
			get
			{
				return _currentNodeType;
			}
			set
			{
				System.Drawing.Color normalControl = System.Drawing.SystemColors.Control;
				System.Drawing.Color hilight = System.Drawing.Color.LightYellow;

				_currentNodeType = value;
				
				groupFileNode.BackColor		= (_currentNodeType == NodeType.FileNode)	? hilight : normalControl;
				groupNameNode.BackColor		= (_currentNodeType == NodeType.NameNode)	? hilight : normalControl;
			}
		}
		
		
		/// <summary>
		/// The stack of dram-pages
		/// </summary>
		System.Collections.ArrayList nodePageStack = new System.Collections.ArrayList();	// ushort's

		/// <summary>
		/// The current node's Dram-Page
		/// </summary>
		ushort currentNodePage = 0;

		/// <summary>
		/// The stack of node Index or Offset values
		/// </summary>
		System.Collections.ArrayList nodeIndexOffsetStack = new System.Collections.ArrayList();	// ushort's

		/// <summary>
		/// The current node's Index or Offset
		/// </summary>
		ushort currentNodeIndexOffset = 0;

		private void fileNodePage_TextChanged(object sender, System.EventArgs e)
		{
			CurrentNodeType = NodeType.FileNode;
			currentNodePage = (ushort)MainForm.TextToValue(16, fileNodePage.Text);
			currentNodeIndexOffset = (ushort)MainForm.TextToValue(10, fileNodeIndex.Text);
			CaptureFile();
		}

		private void fileNodeIndex_TextChanged(object sender, System.EventArgs e)
		{
			CurrentNodeType = NodeType.FileNode;
			currentNodePage = (ushort)MainForm.TextToValue(16, fileNodePage.Text);
			currentNodeIndexOffset = (ushort)MainForm.TextToValue(10, fileNodeIndex.Text);
			CaptureFile();
		}

		private void nameNodePage_TextChanged(object sender, System.EventArgs e)
		{
			CurrentNodeType = NodeType.NameNode;
			currentNodePage = (ushort)MainForm.TextToValue(16, nameNodePage.Text);
			currentNodeIndexOffset = (ushort)MainForm.TextToValue(10, nameNodeOffset.Text);
			CaptureName();
		}

		private void nameNodeOffset_TextChanged(object sender, System.EventArgs e)
		{
			CurrentNodeType = NodeType.NameNode;
			currentNodePage = (ushort)MainForm.TextToValue(16, nameNodePage.Text);
			currentNodeIndexOffset = (ushort)MainForm.TextToValue(10, nameNodeOffset.Text);
			CaptureName();
		}

		private void viewParentName_Click(object sender, System.EventArgs e)
		{
			ushort page		= (ushort)MainForm.TextToValue(16, nameNodePage.Text);
			ushort offset	= (ushort)MainForm.TextToValue(10, nameNodeOffset.Text);

			CurrentNodeType			= NodeType.NameNode;
			currentNodePage			= GetWord(page, (ushort)((int)NameNodeStruct.ParentName + 0 + offset));
			currentNodeIndexOffset	= GetWord(page, (ushort)((int)NameNodeStruct.ParentName + 2 + offset));
			nameNodePage.Text		= currentNodePage.ToString("X4");
			nameNodeOffset.Text		= currentNodeIndexOffset.ToString();
			Push();
		}

		private void viewFileName_Click(object sender, System.EventArgs e)
		{
			ushort page		= (ushort)MainForm.TextToValue(16, fileNodePage.Text);
			ushort index	= (ushort)MainForm.TextToValue(10, fileNodeIndex.Text);

			CurrentNodeType			= NodeType.NameNode;
			currentNodePage			= GetWord(page, (ushort)((int)FileNodeStruct.FileName + 0 + index * (int)FileNodeStruct.SizeOf));
			currentNodeIndexOffset	= GetWord(page, (ushort)((int)FileNodeStruct.FileName + 2 + index * (int)FileNodeStruct.SizeOf));
			nameNodePage.Text		= currentNodePage.ToString("X4");
			nameNodeOffset.Text		= currentNodeIndexOffset.ToString();
			Push();
		}

		private void viewNextSibblingFile_Click(object sender, System.EventArgs e)
		{
			ushort page		= (ushort)MainForm.TextToValue(16, fileNodePage.Text);
			ushort index	= (ushort)MainForm.TextToValue(10, fileNodeIndex.Text);

			CurrentNodeType			= NodeType.FileNode;
			currentNodePage			= GetWord(page, (ushort)((int)FileNodeStruct.NextSibblingFile + 0 + index * (int)FileNodeStruct.SizeOf));
			currentNodeIndexOffset	= GetWord(page, (ushort)((int)FileNodeStruct.NextSibblingFile + 2 + index * (int)FileNodeStruct.SizeOf));
			fileNodePage.Text		= currentNodePage.ToString("X4");
			fileNodeIndex.Text		= currentNodeIndexOffset.ToString();
			Push();
		}

		private void viewPrevSibblingFile_Click(object sender, System.EventArgs e)
		{
			ushort page		= (ushort)MainForm.TextToValue(16, fileNodePage.Text);
			ushort index	= (ushort)MainForm.TextToValue(10, fileNodeIndex.Text);

			CurrentNodeType			= NodeType.FileNode;
			currentNodePage			= GetWord(page, (ushort)((int)FileNodeStruct.PrevSibblingFile + 0 + index * (int)FileNodeStruct.SizeOf));
			currentNodeIndexOffset	= GetWord(page, (ushort)((int)FileNodeStruct.PrevSibblingFile + 2 + index * (int)FileNodeStruct.SizeOf));
			fileNodePage.Text		= currentNodePage.ToString("X4");
			fileNodeIndex.Text		= currentNodeIndexOffset.ToString();
			Push();
		}

		private void viewFirstFileNextFolder_Click(object sender, System.EventArgs e)
		{
			ushort page		= (ushort)MainForm.TextToValue(16, fileNodePage.Text);
			ushort index	= (ushort)MainForm.TextToValue(10, fileNodeIndex.Text);

			CurrentNodeType			= NodeType.FileNode;
			currentNodePage			= GetWord(page, (ushort)((int)FileNodeStruct.FirstFileOfNextFolder + 0 + index * (int)FileNodeStruct.SizeOf));
			currentNodeIndexOffset	= GetWord(page, (ushort)((int)FileNodeStruct.FirstFileOfNextFolder + 2 + index * (int)FileNodeStruct.SizeOf));
			fileNodePage.Text		= currentNodePage.ToString("X4");
			fileNodeIndex.Text		= currentNodeIndexOffset.ToString();
			Push();
		}

		private void viewLastFilePrevFolder_Click(object sender, System.EventArgs e)
		{
			ushort page		= (ushort)MainForm.TextToValue(16, fileNodePage.Text);
			ushort index	= (ushort)MainForm.TextToValue(10, fileNodeIndex.Text);

			CurrentNodeType			= NodeType.FileNode;
			currentNodePage			= GetWord(page, (ushort)((int)FileNodeStruct.LastFileOfPrevFolder + 0 + index * (int)FileNodeStruct.SizeOf));
			currentNodeIndexOffset	= GetWord(page, (ushort)((int)FileNodeStruct.LastFileOfPrevFolder + 2 + index * (int)FileNodeStruct.SizeOf));
			fileNodePage.Text		= currentNodePage.ToString("X4");
			fileNodeIndex.Text		= currentNodeIndexOffset.ToString();
			Push();
		}

		private void stackPop_Click(object sender, System.EventArgs e)
		{
			Pop();
		}

		private void stackPush_Click(object sender, System.EventArgs e)
		{
			Push();
		}
	}
}
