using System;

namespace _8052Sim
{
	/// <summary>
	/// FlashByte objects represent the current state of any particular byte in the Flash Chip.
	/// </summary>
	public class FlashByte
	{
		/// <summary>
		/// Constructor.  All FlashBytes start out their life as "not burned".
		/// </summary>
		public FlashByte()
		{
			isBurned = false;
		}
	
		/// <summary>
		/// Burn a value into a FlashByte.  This can be performed only once per FlashByte.
		/// </summary>
		public void Burn(byte v, String _sourceFile, int _sourceFileLineNumber)
		{
			System.Diagnostics.Debug.Assert(isBurned == false);
			isBurned = true;
			val = v;
			sourceFile = _sourceFile;
			sourceFileLineNumber = _sourceFileLineNumber;
		}
		
		/// <summary>
		/// Discover the value which was burned into a FlashByte
		/// </summary>
		public byte Value
		{
			get
			{
				return val;
			}
		}
		
		/// <summary>
		/// Discover the source file where this byte was burned from.
		/// </summary>
		public String SourceFile
		{
			get
			{
				return sourceFile;
			}
		}
		
		/// <summary>
		/// Discover the line in the source file where this byte was burned from.
		/// </summary>
		public int SourceFileLineNumber
		{
			get
			{
				return sourceFileLineNumber;
			}
		}

		/// <summary>
		/// Allows the outside world to discover whether the byte was burned.
		/// </summary>
		public bool IsBurned
		{
			get	{	return isBurned;	}
		}

		/// <summary>
		/// Keeps track of whether this byte was burned.
		/// </summary>
		private bool isBurned;	// TRUE if a byte has been burned into this location.

		/// <summary>
		/// The value in this byte of flash-ram. 
		/// </summary>
		private byte val;
		
		/// <summary>
		/// The source file where this byte was burned
		/// </summary>
		private String sourceFile;			// where this byte got burned from

		/// <summary>
		/// The line in the source file where this byte was burned
		/// </summary>
		private int sourceFileLineNumber;	// where this byte got burned from		
	}
}
