using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for GlobalsForm.
	/// </summary>
	public class GlobalsForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public GlobalsForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private void GeneralPurposeRegistersForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel = true;	// don't let it get closed!
			MainForm.ToggleGlobals.Checked = !MainForm.ToggleGlobals.Checked;
			Visible = MainForm.ToggleGlobals.Checked;
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.symbolsView = new System.Windows.Forms.ListBox();
			this.showChangesOnly = new System.Windows.Forms.CheckBox();
			this.SuspendLayout();
			// 
			// symbolsView
			// 
			this.symbolsView.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.symbolsView.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.symbolsView.HorizontalScrollbar = true;
			this.symbolsView.ItemHeight = 14;
			this.symbolsView.Location = new System.Drawing.Point(8, 32);
			this.symbolsView.Name = "symbolsView";
			this.symbolsView.ScrollAlwaysVisible = true;
			this.symbolsView.Size = new System.Drawing.Size(488, 200);
			this.symbolsView.TabIndex = 0;
			// 
			// showChangesOnly
			// 
			this.showChangesOnly.Location = new System.Drawing.Point(16, 8);
			this.showChangesOnly.Name = "showChangesOnly";
			this.showChangesOnly.Size = new System.Drawing.Size(136, 16);
			this.showChangesOnly.TabIndex = 1;
			this.showChangesOnly.Text = "Show Changes Only";
			// 
			// GlobalsForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(504, 245);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.showChangesOnly,
																		  this.symbolsView});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.Name = "GlobalsForm";
			this.Text = "GlobalsForm";
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.GeneralPurposeRegistersForm_Closing);
			this.ResumeLayout(false);

		}
		#endregion
		
		public static void AddSymbol(String segName, String symbolName, ushort symbolAddress, ushort symbolBytes)
		{
			symbols.Add(
				new SymbolObject(segName, symbolName, symbolAddress, symbolBytes)
			);
		}

		public ulong GetRootFolder()
		{
			foreach(SymbolObject s in symbols)
			{
				if(s.IsSymbol("__SCANFOLDERS_firstFile"))
				{
					System.Diagnostics.Debug.Assert(s.SizeInBytes == 4);	// expecting a long!!!
					if(XRam.IsLegalAddress(s.Address))
					{
						return XRam.ReadLong(s.Address);
					}
					else
					{
						return 0;
					}
				}
			}
			System.Diagnostics.Debug.Assert(false);	// didn't find it?!?!?
			return 0;
		}
		
		public void CaptureState()
		{
			int topIndex = symbolsView.TopIndex;
			symbolsView.BeginUpdate();
			if(symbolsView.Items.Count == 0)
			{
				for(int n=0;n<symbols.Count;n++)
				{
					String str = symbols[n].ToString();
					if(str != null)
						symbolsView.Items.Add(str);
				}
			}
			else
			{
				// scan all symbols...
				int i = 0;
				for(int n=0;n<symbols.Count;n++)
				{
					String str = symbols[n].ToString();
					if(str != null)
					{
						if( 
							(showChangesOnly.Checked && (str[0] != ' ')) || 
							(!showChangesOnly.Checked)
						)
							symbolsView.Items[i++] = str;
					}
				}
				while(i < symbolsView.Items.Count)
					symbolsView.Items[i++] = "";
			}
			symbolsView.TopIndex = topIndex;
			symbolsView.EndUpdate();
		}

		private System.Windows.Forms.ListBox symbolsView;
		private System.Windows.Forms.CheckBox showChangesOnly;
		
		private static System.Collections.ArrayList symbols = new System.Collections.ArrayList();	// SymbolObject's
	}
}
