using System;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for Dram.
	/// </summary>
	public class Dram
	{
		/// <summary>
		/// Allocate all pages of DRAM
		/// </summary>
		public static void Startup()
		{
			page = new PageOfDram[NPAGES];
			for(ushort n = 0; n < NPAGES; n++)
				page[n] = new PageOfDram(n);
		}


		/// <summary>
		/// Returns a specific page of DRAM.  (0..8192) for 32 megs.
		/// </summary>
		public static PageOfDram GetPageNumber(ushort pageIndex)
		{
			if( (pageIndex >= 0) && (pageIndex < NPAGES) )
				return page[pageIndex];
			return null;
		}
		
		
		/// <summary>
		/// Number of bytes of DRAM which we will simulate.
		/// </summary>
		private static readonly int BYTES = 32*1024*1024;	// size of Dram Chip

		/// <summary>
		/// Number of pages of DRAM which we will simulate.
		/// </summary>
		private static readonly int NPAGES = BYTES / 4096;
		

		/// <summary>
		/// All pages of DRAM.
		/// </summary>
		private static PageOfDram[] page;
	}
}
