using System;

namespace _8052Sim
{
	/// <summary>
	/// Ide is the object which emulates the Xilinx side of the IDE bus.
	/// </summary>
	public class Ide
	{
		/// <summary>
		/// Initialize the IDE object
		/// </summary>
		public static void Startup()
		{
			device[0] = new IdeDevice(false,	"TravelStar20Gig.image");
//			device[0] = new IdeDevice(false,	"WD30Gig.image");
//			device[0] = new IdeDevice(false,	"SmallPartition.image");
			device[1] = new IdeDevice(true,		"");
			HardReset();
			currentDevice = device[0];
		}
		
		/// <summary>
		/// Reset the IDE device.
		/// </summary>
		public static void HardReset()
		{
			System.Diagnostics.Debugger.Log(0, "IDE", "Ide - Hard Reset\n");
		}
		
		public static byte DeviceHeadRegister
		{
			set	
			{
				// ensure the "currentDevice" is correct.
				if((value & 0x10) == 0)
					currentDevice = device[0];
				else
					currentDevice = device[1];
				
				currentDevice.DeviceHeadRegister = value;
			}
		}
		
		public static byte AlternateStatusRegister
		{
			get
			{
				return currentDevice.AlternateStatusRegister;
			}
		}
		
		public static byte SectorNumberRegister
		{
			set
			{
				currentDevice.SectorNumberRegister = value;
			}
		}
		
		public static byte CylinderLowRegister
		{
			set
			{
				currentDevice.CylinderLowRegister = value;
			}
		}
		
		public static byte CylinderHighRegister
		{
			set
			{
				currentDevice.CylinderHighRegister = value;
			}
		}
		
		public static byte SectorCountRegister
		{
			set
			{
				currentDevice.SectorCountRegister = value;
			}
		}
		
		public static byte IdeFeatureRegister
		{
			set
			{
				currentDevice.IdeFeatureRegister = value;
			}
		}
		
		public static byte CommandRegister
		{
			set
			{
				currentDevice.CommandRegister = value;
			}
		}

		public static ushort PIO
		{
			get
			{
				return currentDevice.PIO;
			}
		}		


		private static IdeDevice currentDevice;

		private static IdeDevice[] device = new IdeDevice[2];
	}
}
