using System;

namespace _8052Sim
{
	/// <summary>
	/// This is a 4K page of DRAM Memory.
	/// </summary>
	public class PageOfDram
	{
		/// <summary>
		/// Initialize the DRAM to be random.
		/// </summary>
		public PageOfDram(ushort number)
		{
			pageNumber = number;
//			MainForm.Randy.NextBytes(memory);
			for(int n=0;n<memory.Length;n++)
				memory[n] = 0xcc;
		}
		
		
		/// <summary>
		/// Fetch a byte from this page, at the specified offset.
		/// offset = 0x0000..0x0fff
		/// </summary>
		public byte Read8(ushort offset)
		{
			return memory[offset];
		}


		/// <summary>
		/// Fetch a short from this page, at the specified offset.
		/// offset = 0x0000..0x0fff
		/// </summary>
		public ushort Read16(ushort offset)
		{
			return (ushort)(memory[offset + 0] + memory[offset + 1] * 256);
		}


		/// <summary>
		/// Fetch a long from this page, at the specified offset.
		/// offset = 0x0000..0x0fff
		/// </summary>
		public ulong Read32(ushort offset)
		{
			return (ulong)(
				 memory[offset + 0] + 
				(memory[offset + 1]<<8) +
				(memory[offset + 2]<<16) +
				(memory[offset + 3]<<24)
			);
		}


		/// <summary>
		/// Fetch a byte from this page, at the specified offset.
		/// offset = 0x0000..0x0fff
		/// </summary>
		public void Write8(ushort offset, byte val)
		{
			memory[offset] = val;
		}


		/// <summary>
		/// Storage space for the bytes in this page of DRAM.
		/// </summary>
		private byte[] memory = new byte[0x1000];
		
		/// <summary>
		/// The page remembers which number it is!!!
		/// </summary>
		private ushort pageNumber;
		
		public ushort PageNumber
		{
			get {	return pageNumber;	}
		}
	}
}
