using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for InternalMemoryForm.
	/// </summary>
	public class InternalMemoryForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public InternalMemoryForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// InternalMemoryForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(346, 202);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.MaximizeBox = false;
			this.Name = "InternalMemoryForm";
			this.Text = "8052 Internal Memory";
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.InternalMemoryForm_Closing);
			this.Load += new System.EventHandler(this.InternalMemoryForm_Load);

		}
		#endregion

		private void InternalMemoryForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel = true;	// don't let it get closed!
			MainForm.ToggleInternalMemoryMenuItem.Checked = !MainForm.ToggleInternalMemoryMenuItem.Checked;
			Visible = MainForm.ToggleInternalMemoryMenuItem.Checked;
		}

		private void InternalMemoryForm_Load(object sender, System.EventArgs e)
		{
			if(loaded == false)
			{
				int n;
				for(n=0;n<textBoxes.Length;n++)
				{
					if( (n & 15) == 0 )
					{
						System.Windows.Forms.Label label = new System.Windows.Forms.Label();
						label.Text = n.ToString("x2");
						label.Location = new System.Drawing.Point(0, (n/16)*24+4);
						label.Font = new Font(FontFamily.GenericMonospace, 8);
						label.Width = 24;
						this.Controls.Add(label);
					}
					
					System.Windows.Forms.TextBox textBox = new System.Windows.Forms.TextBox();
					textBox.Location = new System.Drawing.Point(24+(n%16)*32, (n/16)*24);
					textBox.Font = new Font(FontFamily.GenericMonospace, 8);
					textBox.Width = 24;
					this.Controls.Add(textBox);
					textBoxes[n] = textBox;
				}
				this.Width = 24+((n+15)%16)*32+32;
				this.Height = ((n+15)/16)*24+24;
				loaded = true;
			}
		}
		
		// captures the state of internal ram in the CPU, on the screen.
		public void CaptureState()
		{
			for(int n=0;n<textBoxes.Length;n++)
			{
				if(textBoxes[n] != null)
				{
					String[] lines = {Cpu8052.GetInternalRam((byte)n).ToString("x2")};
					textBoxes[n].Lines = lines;
				}
			}			
		}
		
		bool loaded = false;
		System.Windows.Forms.TextBox[] textBoxes = new System.Windows.Forms.TextBox[256];
	}
}
