using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MenuItem StepOverInstruction;
		private System.Windows.Forms.MenuItem StepIntoInstruction;
		private System.Windows.Forms.MenuItem RunSimulation;
		private System.Windows.Forms.ListBox sourceView;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem toggleGeneralPurposeRegs;
		private System.Windows.Forms.MenuItem toggleOtherGeneralPurposeRegs;
		private System.Windows.Forms.MenuItem toggleInterruptRegs;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem sourceFileMenu;
		private System.Windows.Forms.MenuItem MoveCursorToPC;
		private System.Windows.Forms.MenuItem RestartSimulationMenuItem;
		private System.Windows.Forms.MenuItem FileMenu;
		private System.Windows.Forms.MenuItem EditMenu;
		private System.Windows.Forms.MenuItem ViewMenu;
		private System.Windows.Forms.MenuItem SimulationMenu;
		private System.Windows.Forms.MenuItem BreakpointsMenu;
		private System.Windows.Forms.MenuItem toggleInternalMemoryMenuItem;
		private System.Windows.Forms.MenuItem BreakMenuItem;
		private System.Windows.Forms.MenuItem SimulationStateMenuItem;
		private System.Windows.Forms.MenuItem ToggleBreakpointMenuItem;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem toggleSerialPowerRegs;
		private System.Windows.Forms.MenuItem toggleTimerCounterRegs;
		private System.Windows.Forms.MenuItem toggleTerminalWindow;
		private System.Windows.Forms.MenuItem toggleProgramStatusRegMenuItem;
		private System.Windows.Forms.MenuItem StepOutOfSubroutine;
		private System.Windows.Forms.MenuItem toggleGlobalVariables;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItem10;
		public System.Windows.Forms.Label currentSegment;
		private System.Windows.Forms.MenuItem toggleExternalMemoryMenuItem;
		private System.Windows.Forms.MenuItem menuItem13;
		private System.Windows.Forms.MenuItem menuItem12;
		private System.Windows.Forms.MenuItem toggleDRamMemoryMenuItem;
		private System.Windows.Forms.MenuItem toggleFileTreeBrowserMenuItem;
		
		
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MainForm()
		{
			theMainForm = this;
			mainThread = System.Threading.Thread.CurrentThread;

			// use a low-priority while the simulator starts-up, 
			// just so it doesn't hog the CPU
			mainThread.Priority = System.Threading.ThreadPriority.Lowest;
			
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			// make the background transparent for TV cards...
			// (I like to work while watching tv :-)
			MainForm.SourceView.BackColor = System.Drawing.Color.FromArgb(16,0,16);
			
			this.Visible = true;
			
			Sta013.Startup();
			Dram.Startup();
			Ide.Startup();
			Xilinx.Startup();
			Flash.Startup();		// scan all .rst files to produce an image of the flash memory.
			Simulation.Startup();	// start the thread which runs the simulation.
			
			generalPurposeRegsForm = new GeneralPurposeRegsForm();
			internalMemoryForm = new InternalMemoryForm();
			externalMemoryForm = new ExternalMemoryForm();
			dramMemoryForm = new DRamMemoryForm();
			fileTreeBrowserForm = new FileTreeBrowserForm();
			timerCounterRegistersForm = new TimerCounterRegistersForm();
			terminalWindowForm = new TerminalWindowForm();
			serialPowerRegistersForm = new SerialPowerRegistersForm();
			programStatusWordForm = new ProgramStatusWordForm();
			globalVariablesForm = new GlobalsForm();
			
			System.Diagnostics.Debugger.Log(0, "Simulation", "MainForm Thread = "+System.Threading.Thread.CurrentThread.Name+"\n");

			CommandFifo.Restart();

			// return to "normal" priority 
			mainThread.Priority = System.Threading.ThreadPriority.Normal;
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.FileMenu = new System.Windows.Forms.MenuItem();
			this.EditMenu = new System.Windows.Forms.MenuItem();
			this.ViewMenu = new System.Windows.Forms.MenuItem();
			this.sourceFileMenu = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.toggleGeneralPurposeRegs = new System.Windows.Forms.MenuItem();
			this.toggleOtherGeneralPurposeRegs = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.toggleProgramStatusRegMenuItem = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.toggleInterruptRegs = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.toggleSerialPowerRegs = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.toggleTimerCounterRegs = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.MoveCursorToPC = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.toggleInternalMemoryMenuItem = new System.Windows.Forms.MenuItem();
			this.toggleExternalMemoryMenuItem = new System.Windows.Forms.MenuItem();
			this.toggleDRamMemoryMenuItem = new System.Windows.Forms.MenuItem();
			this.menuItem12 = new System.Windows.Forms.MenuItem();
			this.toggleGlobalVariables = new System.Windows.Forms.MenuItem();
			this.menuItem13 = new System.Windows.Forms.MenuItem();
			this.toggleTerminalWindow = new System.Windows.Forms.MenuItem();
			this.toggleFileTreeBrowserMenuItem = new System.Windows.Forms.MenuItem();
			this.SimulationMenu = new System.Windows.Forms.MenuItem();
			this.RestartSimulationMenuItem = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.RunSimulation = new System.Windows.Forms.MenuItem();
			this.BreakMenuItem = new System.Windows.Forms.MenuItem();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.StepOverInstruction = new System.Windows.Forms.MenuItem();
			this.StepIntoInstruction = new System.Windows.Forms.MenuItem();
			this.StepOutOfSubroutine = new System.Windows.Forms.MenuItem();
			this.BreakpointsMenu = new System.Windows.Forms.MenuItem();
			this.ToggleBreakpointMenuItem = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.SimulationStateMenuItem = new System.Windows.Forms.MenuItem();
			this.sourceView = new System.Windows.Forms.ListBox();
			this.currentSegment = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.FileMenu,
																					 this.EditMenu,
																					 this.ViewMenu,
																					 this.SimulationMenu,
																					 this.BreakpointsMenu,
																					 this.SimulationStateMenuItem});
			// 
			// FileMenu
			// 
			this.FileMenu.Index = 0;
			this.FileMenu.Text = "File";
			// 
			// EditMenu
			// 
			this.EditMenu.Index = 1;
			this.EditMenu.Text = "Edit";
			// 
			// ViewMenu
			// 
			this.ViewMenu.Index = 2;
			this.ViewMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.sourceFileMenu,
																					 this.menuItem1,
																					 this.menuItem5,
																					 this.MoveCursorToPC,
																					 this.menuItem6,
																					 this.toggleInternalMemoryMenuItem,
																					 this.toggleExternalMemoryMenuItem,
																					 this.toggleDRamMemoryMenuItem,
																					 this.menuItem12,
																					 this.toggleGlobalVariables,
																					 this.toggleFileTreeBrowserMenuItem,
																					 this.menuItem13,
																					 this.toggleTerminalWindow});
			this.ViewMenu.Text = "View";
			// 
			// sourceFileMenu
			// 
			this.sourceFileMenu.Index = 0;
			this.sourceFileMenu.Text = "Source File...";
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 1;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.toggleGeneralPurposeRegs,
																					  this.toggleOtherGeneralPurposeRegs,
																					  this.menuItem7,
																					  this.toggleProgramStatusRegMenuItem,
																					  this.menuItem2,
																					  this.toggleInterruptRegs,
																					  this.menuItem3,
																					  this.toggleSerialPowerRegs,
																					  this.menuItem4,
																					  this.toggleTimerCounterRegs});
			this.menuItem1.Text = "Registers...";
			// 
			// toggleGeneralPurposeRegs
			// 
			this.toggleGeneralPurposeRegs.Index = 0;
			this.toggleGeneralPurposeRegs.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftG;
			this.toggleGeneralPurposeRegs.Text = "A, B, DPTR, R0..R7,PC - General Purpose Registers";
			this.toggleGeneralPurposeRegs.Click += new System.EventHandler(this.ToggleGeneralPurposeRegs_Click);
			// 
			// toggleOtherGeneralPurposeRegs
			// 
			this.toggleOtherGeneralPurposeRegs.Index = 1;
			this.toggleOtherGeneralPurposeRegs.Text = "R0..R7 in all banks - Other General Purpose Registers";
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 2;
			this.menuItem7.Text = "P0..P3 - Port Registers";
			// 
			// toggleProgramStatusRegMenuItem
			// 
			this.toggleProgramStatusRegMenuItem.Index = 3;
			this.toggleProgramStatusRegMenuItem.Text = "PSW - Program Status Word";
			this.toggleProgramStatusRegMenuItem.Click += new System.EventHandler(this.toggleProgramStatusReg_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 4;
			this.menuItem2.Text = "-";
			// 
			// toggleInterruptRegs
			// 
			this.toggleInterruptRegs.Index = 5;
			this.toggleInterruptRegs.Text = "IE, IP - Interrupt Registers";
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 6;
			this.menuItem3.Text = "-";
			// 
			// toggleSerialPowerRegs
			// 
			this.toggleSerialPowerRegs.Index = 7;
			this.toggleSerialPowerRegs.Text = "SBUF, SCON, PCON - Serial Port && Power Control";
			this.toggleSerialPowerRegs.Click += new System.EventHandler(this.ToggleSerialPowerRegs_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 8;
			this.menuItem4.Text = "-";
			// 
			// toggleTimerCounterRegs
			// 
			this.toggleTimerCounterRegs.Index = 9;
			this.toggleTimerCounterRegs.Text = "TCON, TMOD, TH0, TL0, TH1, TL1 - Timer/Counters";
			this.toggleTimerCounterRegs.Click += new System.EventHandler(this.toggleTimerRegs_Click);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 2;
			this.menuItem5.Text = "-";
			// 
			// MoveCursorToPC
			// 
			this.MoveCursorToPC.Index = 3;
			this.MoveCursorToPC.Text = "Move Cursor to PC";
			this.MoveCursorToPC.Click += new System.EventHandler(this.MoveCursorToPC_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 4;
			this.menuItem6.Text = "-";
			// 
			// toggleInternalMemoryMenuItem
			// 
			this.toggleInternalMemoryMenuItem.Index = 5;
			this.toggleInternalMemoryMenuItem.Text = "Internal Memory";
			this.toggleInternalMemoryMenuItem.Click += new System.EventHandler(this.internalMemoryMenuItem_Click);
			// 
			// toggleExternalMemoryMenuItem
			// 
			this.toggleExternalMemoryMenuItem.Index = 6;
			this.toggleExternalMemoryMenuItem.Text = "XRam Memory";
			this.toggleExternalMemoryMenuItem.Click += new System.EventHandler(this.toggleExternalMemoryMenuItem_Click);
			// 
			// toggleDRamMemoryMenuItem
			// 
			this.toggleDRamMemoryMenuItem.Index = 7;
			this.toggleDRamMemoryMenuItem.Text = "DRam Pages";
			this.toggleDRamMemoryMenuItem.Click += new System.EventHandler(this.toggleDRamMemoryMenuItem_Click);
			// 
			// menuItem12
			// 
			this.menuItem12.Index = 8;
			this.menuItem12.Text = "-";
			// 
			// toggleGlobalVariables
			// 
			this.toggleGlobalVariables.Index = 9;
			this.toggleGlobalVariables.Text = "Global Variables";
			this.toggleGlobalVariables.Click += new System.EventHandler(this.toggleGlobalVariables_Click);
			// 
			// menuItem13
			// 
			this.menuItem13.Index = 11;
			this.menuItem13.Text = "-";
			// 
			// toggleTerminalWindow
			// 
			this.toggleTerminalWindow.Index = 12;
			this.toggleTerminalWindow.Text = "Terminal Window";
			this.toggleTerminalWindow.Click += new System.EventHandler(this.toggleTerminalWindow_Click);
			// 
			// toggleFileTreeBrowserMenuItem
			// 
			this.toggleFileTreeBrowserMenuItem.Index = 10;
			this.toggleFileTreeBrowserMenuItem.Text = "FileTree Browser";
			this.toggleFileTreeBrowserMenuItem.Click += new System.EventHandler(this.toggleFileTreeBrowserWindow_Click);
			// 
			// SimulationMenu
			// 
			this.SimulationMenu.Index = 3;
			this.SimulationMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						   this.RestartSimulationMenuItem,
																						   this.menuItem9,
																						   this.RunSimulation,
																						   this.BreakMenuItem,
																						   this.menuItem10,
																						   this.StepOverInstruction,
																						   this.StepIntoInstruction,
																						   this.StepOutOfSubroutine});
			this.SimulationMenu.Text = "Simulation";
			// 
			// RestartSimulationMenuItem
			// 
			this.RestartSimulationMenuItem.Index = 0;
			this.RestartSimulationMenuItem.Shortcut = System.Windows.Forms.Shortcut.ShiftF5;
			this.RestartSimulationMenuItem.Text = "Restart Simulation";
			this.RestartSimulationMenuItem.Click += new System.EventHandler(this.RestartSimulation_Click);
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 1;
			this.menuItem9.Text = "-";
			// 
			// RunSimulation
			// 
			this.RunSimulation.Index = 2;
			this.RunSimulation.Shortcut = System.Windows.Forms.Shortcut.F5;
			this.RunSimulation.Text = "Run";
			this.RunSimulation.Click += new System.EventHandler(this.RunSimulation_Click);
			// 
			// BreakMenuItem
			// 
			this.BreakMenuItem.Index = 3;
			this.BreakMenuItem.Shortcut = System.Windows.Forms.Shortcut.F12;
			this.BreakMenuItem.Text = "Break";
			this.BreakMenuItem.Click += new System.EventHandler(this.BreakMenuItem_Click);
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 4;
			this.menuItem10.Text = "-";
			// 
			// StepOverInstruction
			// 
			this.StepOverInstruction.Index = 5;
			this.StepOverInstruction.Shortcut = System.Windows.Forms.Shortcut.F10;
			this.StepOverInstruction.Text = "Step Over";
			this.StepOverInstruction.Click += new System.EventHandler(this.StepOverInstruction_Click);
			// 
			// StepIntoInstruction
			// 
			this.StepIntoInstruction.Index = 6;
			this.StepIntoInstruction.Shortcut = System.Windows.Forms.Shortcut.F11;
			this.StepIntoInstruction.Text = "Step Into";
			this.StepIntoInstruction.Click += new System.EventHandler(this.StepIntoInstruction_Click);
			// 
			// StepOutOfSubroutine
			// 
			this.StepOutOfSubroutine.Index = 7;
			this.StepOutOfSubroutine.Shortcut = System.Windows.Forms.Shortcut.ShiftF11;
			this.StepOutOfSubroutine.Text = "Step Out";
			this.StepOutOfSubroutine.Click += new System.EventHandler(this.StepOutOfSubroutine_Click);
			// 
			// BreakpointsMenu
			// 
			this.BreakpointsMenu.Index = 4;
			this.BreakpointsMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																							this.ToggleBreakpointMenuItem,
																							this.menuItem8});
			this.BreakpointsMenu.Text = "Breakpoints";
			// 
			// ToggleBreakpointMenuItem
			// 
			this.ToggleBreakpointMenuItem.Index = 0;
			this.ToggleBreakpointMenuItem.Shortcut = System.Windows.Forms.Shortcut.F9;
			this.ToggleBreakpointMenuItem.Text = "Toggle Breakpoint";
			this.ToggleBreakpointMenuItem.Click += new System.EventHandler(this.ToggleBreakpointMenuItem_Click);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 1;
			this.menuItem8.Text = "View Breakpoints";
			// 
			// SimulationStateMenuItem
			// 
			this.SimulationStateMenuItem.Enabled = false;
			this.SimulationStateMenuItem.Index = 5;
			this.SimulationStateMenuItem.Text = "[Burning Flash]";
			// 
			// sourceView
			// 
			this.sourceView.AccessibleDescription = "View of current code file";
			this.sourceView.AccessibleName = "Source View";
			this.sourceView.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.sourceView.BackColor = System.Drawing.Color.White;
			this.sourceView.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.sourceView.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.sourceView.HorizontalScrollbar = true;
			this.sourceView.ItemHeight = 14;
			this.sourceView.Location = new System.Drawing.Point(8, 8);
			this.sourceView.Name = "sourceView";
			this.sourceView.Size = new System.Drawing.Size(800, 504);
			this.sourceView.TabIndex = 1;
			this.sourceView.DoubleClick += new System.EventHandler(this.sourceView_DoubleClick);
			// 
			// currentSegment
			// 
			this.currentSegment.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.currentSegment.Location = new System.Drawing.Point(792, 0);
			this.currentSegment.Name = "currentSegment";
			this.currentSegment.Size = new System.Drawing.Size(24, 24);
			this.currentSegment.TabIndex = 2;
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(816, 521);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.sourceView,
																		  this.currentSegment});
			this.Menu = this.mainMenu;
			this.Name = "MainForm";
			this.Text = "MP3 Simulator";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());

			Simulation.Dispose();
		}
		
		private static MainForm theMainForm;
		
		public static GeneralPurposeRegsForm generalPurposeRegsForm;
		public static InternalMemoryForm internalMemoryForm;
		public static ExternalMemoryForm externalMemoryForm;
		public static DRamMemoryForm dramMemoryForm;
		public static FileTreeBrowserForm fileTreeBrowserForm;
		public static TimerCounterRegistersForm timerCounterRegistersForm;
		public static TerminalWindowForm terminalWindowForm;
		public static ProgramStatusWordForm programStatusWordForm;
		public static SerialPowerRegistersForm serialPowerRegistersForm;
		public static GlobalsForm globalVariablesForm;

		public static String currentSourceFileBeingViewed;
		public static int currentLineBeingViewed;

		/// <summary>
		/// Accessor for the Terminal window...
		/// </summary>
		public static TerminalWindowForm TerminalWindow
		{
			get
			{
				return terminalWindowForm;
			}
		}
		
		
		/// <summary>
		/// Toggle display of the General Purpose Registers Window.
		/// </summary>
		private void ToggleGeneralPurposeRegs_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			generalPurposeRegsForm.Visible = item.Checked;
			if(generalPurposeRegsForm.Visible)
				generalPurposeRegsForm.CaptureState();
		}

		/// <summary>
		/// Toggle display of the Internal RAM Window.
		/// </summary>
		private void internalMemoryMenuItem_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			internalMemoryForm.Visible = item.Checked;
			if(internalMemoryForm.Visible)
				internalMemoryForm.CaptureState();
		}

		/// <summary>
		/// Toggle display of the Timer/Counter Registers.
		/// </summary>
		private void toggleTimerRegs_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			timerCounterRegistersForm.Visible = item.Checked;
			if(timerCounterRegistersForm.Visible)
				timerCounterRegistersForm.CaptureState();
		}

		/// <summary>
		/// Ask Source Window to re-center on PC
		/// </summary>
		private void MoveCursorToPC_Click(object sender, System.EventArgs e)
		{
			SourceViewJumpToPC();
		}
		
		/// <summary>
		/// Move the source-view's display to center on the current IP.
		/// </summary>
		public static void SourceViewJumpToPC()
		{
			String fn = Flash.RstSourceFile(Cpu8052.Pc, Flash.A16);
			if(fn != null)
			{
				// we have source-code!
				SourceViewJumpTo(
					fn,
					Flash.RstSourceFileLineNumber(Cpu8052.Pc, Flash.A16)
				);
			}
			else
			{
				// no source code available!
				SourceViewShowDisassembly();
			}
		}

		/// <summary>
		/// Move the source-view's display to the specified file.
		/// </summary>
		public static void SourceViewJumpTo(String file)
		{
			SourceViewJumpTo(file, 0/*no line*/);
		}

		private void toggleProgramStatusReg_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			programStatusWordForm.Visible = item.Checked;
			if(programStatusWordForm.Visible)
				programStatusWordForm.CaptureState();
		}

		private void toggleTerminalWindow_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			terminalWindowForm.Visible = item.Checked;
			if(terminalWindowForm.Visible)
				terminalWindowForm.CaptureState();
		}

		private void ToggleSerialPowerRegs_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			serialPowerRegistersForm.Visible = item.Checked;
			if(serialPowerRegistersForm.Visible)
				serialPowerRegistersForm.CaptureState();
		}

		private static int syncRootSourceView = 0;
		
		public static void LockSourceView()
		{
			// wait for access to sourceView
			while(System.Threading.Interlocked.Increment(ref syncRootSourceView) != 1)
			{
				System.Threading.Interlocked.Decrement(ref syncRootSourceView);
				System.Threading.Thread.Sleep(10);
			}
		}
		
		public static void UnlockSourceView()
		{
			System.Threading.Interlocked.Decrement(ref syncRootSourceView);
		}
		
		
		/// <summary>
		/// Toggle the existance of a breakpoint on a specific line of source-code.
		/// NOTE: The breakpoint may be created on another line, if the desired line
		/// generates no code.  In that event, the next line which DOES generate code,
		/// will be used.
		/// </summary>
		private void ToggleBreakpointMenuItem_Click(object sender, System.EventArgs e)
		{
			LockSourceView();

			int line = sourceView.SelectedIndex+1;
			if(line>0)	// only if something is *actually selected*
			{
				int addr = Flash.FindAddress(
					currentSourceFileBeingViewed,
					line
				);

				if(String.Compare(Flash.RstSourceFile((ushort)addr,((addr&0x10000)!=0)?true:false), currentSourceFileBeingViewed) == 0)
				{
					line = Flash.RstSourceFileLineNumber((ushort)addr,((addr&0x10000)!=0)?true:false);
				}
				else
				{
					line = 0;	// no line in current source view!
				}
				
				if(line > 0)
				{
					if(BreakpointManager.BreakpointExistsAt(addr))
						BreakpointManager.RemoveBreakpoint(addr);
					else
						BreakpointManager.AddFlashBreakpoint(addr);	// throw-away the reference to the breakpoint, we don't need it...

					SourceView.BeginUpdate();
					SourceView.Items[line-1] = DecorateSourceLine(
						true,
						addr, 
						FileCache.File(currentSourceFileBeingViewed)[line-1]
					);
					SourceView.EndUpdate();
				}
			}
			UnlockSourceView();
		}

		/// <summary>
		/// Accepts a line of text which describes the address specified.
		/// This routine then decorates the beginning of the line as
		/// appropriate, depending on breakpoints, current PC, etc.
		/// </summary>
		private static String DecorateSourceLine(bool doDecorate, int addr, String str)
		{
			bool brk = BreakpointManager.BreakpointExistsAt(addr);
			bool pc = (Cpu8052.Pc + (Flash.A16?0x10000:0)) == addr;
			
			// if we're asked not to decorate the line, then defeat all the checks above.
			if(!doDecorate)
			{
				brk = false;
				pc = false;
			}
			
			if(brk)
			{
				if(pc)
				{
					str = "-B>" + str;
				}
				else
				{
					str = "[B]" + str;
				}
			}
			else
			{
				if(pc)
				{
					str = "-->" + str;
				}
				else
				{
					str = "   " + str;
				}
			}
			return str;
		}
		
		/// <summary>
		/// Toggle a breakpoint at this position in the currently displayed file.
		/// </summary>
		private void sourceView_DoubleClick(object sender, System.EventArgs e)
		{
			ToggleBreakpointMenuItem_Click(sender, e);
		}

		/// <summary>
		/// Ask the simulation to run until the next breakpoint.
		/// </summary>
		private void RunSimulation_Click(object sender, System.EventArgs e)
		{
			CommandFifo.Run();
		}

		/// <summary>
		/// Ask simulation to stop running now!
		/// </summary>
		private void BreakMenuItem_Click(object sender, System.EventArgs e)
		{
			CommandFifo.Break();
		}

		/// <summary>
		/// Ask simulation to step over current instruction
		/// </summary>
		private void StepOverInstruction_Click(object sender, System.EventArgs e)
		{
			CommandFifo.StepOver();
		}

		/// <summary>
		/// Ask simulation to step into current instruction
		/// </summary>
		private void StepIntoInstruction_Click(object sender, System.EventArgs e)
		{
			CommandFifo.StepInto();
		}

		/// <summary>
		/// Ask simulation to run until returning from the routine.
		/// Implemented by running until SP drops below current value.
		/// </summary>
		private void StepOutOfSubroutine_Click(object sender, System.EventArgs e)
		{
			CommandFifo.StepOut();
		}
		

		/// <summary>
		/// Ask simulation to hard-reset 
		/// </summary>
		private void RestartSimulation_Click(object sender, System.EventArgs e)
		{
			CommandFifo.Restart();
		}

		/// <summary>
		/// Convert a string to a value, for register tool windows.
		/// </summary>
		public static int TextToValue(int numericBase, String str)
		{
//			bool illegal = false;
			int v = 0;
			char[] chars = str.ToCharArray();
			foreach(char cc in chars)
			{
				v *= numericBase;
				char c = System.Char.ToUpper(cc);
				switch(numericBase)
				{
					case 2:
					case 10:
						if(System.Char.IsDigit(c))
							v += (c - '0');
//						else
//							illegal = true;
						break;
					
					case 16:
						if(System.Char.IsDigit(c))
							v += (c - '0');
						else if( (c >= 'A') && (c <= 'F') )
							v += (c - 'A') + 10;
//						else
//							illegal = true;
						break;

					default:
						System.Diagnostics.Debug.Assert(false);
						break;
				}
			}
			return v;
		}

		/// <summary>
		/// Convert an 8-bit value into a string, for register tool windows..
		/// </summary>
		public static void Reg8ToText(
			int numericBase, 
			int val,
			System.Windows.Forms.TextBox textBox, 
			System.Drawing.Color hilight, 
			System.Drawing.Color normal)
		{
			String[] lines = new String[1];
			String formatString;
			switch(numericBase)
			{
				case 2:		formatString = "B8";	break;
				case 10:	formatString = "D3";	break;
				case 16:	formatString = "X2";	break;

				default:
					System.Diagnostics.Debug.Assert(false);
					formatString = "";
					break;
			}
			lines[0] = val.ToString(formatString);
			if(textBox.Lines.Length != 0)
			{
				if(textBox.Lines[0].CompareTo(lines[0])!=0)
				{
					textBox.Lines = lines;
					textBox.BackColor = hilight;
				}
				else
				{
					textBox.BackColor = normal;
				}
			}
		}
		
		/// <summary>
		/// Convert a 16-bit value into a string, for register tool windows..
		/// </summary>
		public static void Reg16ToText(
			int numericBase, 
			int val,
			System.Windows.Forms.TextBox textBox, 
			System.Drawing.Color hilight, 
			System.Drawing.Color normal)
		{
			String[] lines = new String[1];
			String formatString;
			switch(numericBase)
			{
				case 2:		formatString = "B16";	break;
				case 10:	formatString = "D5";	break;
				case 16:	formatString = "X4";	break;

				default:
					System.Diagnostics.Debug.Assert(false);
					formatString = "";
					break;
			}
			lines[0] = val.ToString(formatString);
			if(textBox.Lines.Length != 0)
			{
				if(textBox.Lines[0].CompareTo(lines[0])!=0)
				{
					textBox.Lines = lines;
					textBox.BackColor = hilight;
				}
				else
				{
					textBox.BackColor = normal;
				}
			}
		}
		
		public static System.Windows.Forms.MenuItem SourceFileMenu
		{
			get	{	return theMainForm.sourceFileMenu;	}
		}

		public static System.Windows.Forms.MenuItem SimulationStateMenu
		{
			get	{	return theMainForm.SimulationStateMenuItem;	}
		}

		public static System.Windows.Forms.ListBox SourceView
		{
			get	{	return theMainForm.sourceView;	}
		}

		public static System.Windows.Forms.MenuItem ToggleGeneralPurposeRegs
		{
			get	{	return theMainForm.toggleGeneralPurposeRegs;	}
		}
		
		public static System.Windows.Forms.MenuItem ToggleTimerCounterRegs
		{
			get	{	return theMainForm.toggleTimerCounterRegs;	}
		}
		
		public static System.Windows.Forms.MenuItem ToggleSerialPowerRegs
		{
			get	{	return theMainForm.toggleSerialPowerRegs;	}
		}
		
		public static System.Windows.Forms.MenuItem ToggleTerminalWindow
		{
			get	{	return theMainForm.toggleTerminalWindow;	}
		}
		
		public static System.Windows.Forms.MenuItem ToggleGlobals
		{
			get	{	return theMainForm.toggleGlobalVariables;	}
		}
		
		public static System.Windows.Forms.MenuItem ToggleOtherGeneralPurposeRegs
		{
			get	{	return theMainForm.toggleOtherGeneralPurposeRegs;	}
		}

		public static System.Windows.Forms.MenuItem ToggleInternalMemoryMenuItem
		{
			get	{	return theMainForm.toggleInternalMemoryMenuItem;	}
		}

		public static System.Windows.Forms.MenuItem ToggleExternalMemoryMenuItem
		{
			get	{	return theMainForm.toggleExternalMemoryMenuItem;	}
		}

		public static System.Windows.Forms.MenuItem ToggleDRamMemoryMenuItem
		{
			get	{	return theMainForm.toggleDRamMemoryMenuItem;	}
		}

		public static System.Windows.Forms.MenuItem ToggleFileTreeBrowserMenuItem
		{
			get	{	return theMainForm.toggleFileTreeBrowserMenuItem;	}
		}

		public static System.Windows.Forms.MenuItem ToggleProgramStatusWordMenuItem
		{
			get	{	return theMainForm.toggleProgramStatusRegMenuItem;	}
		}

		private static System.Threading.Thread mainThread;

		/// <summary>
		/// Show a specific part of a source file!
		/// </summary>
		public static void SourceViewJumpTo(String filename, int lineNumber)
		{
//			System.Diagnostics.Debugger.Log(0, "SrcView", "Displayer = "+System.Threading.Thread.CurrentThread.Name+"\n");
//			System.Diagnostics.Debugger.Log(0, "SrcView", "Begin\n");
			theMainForm.Text = "8052Sim: " + filename;
			LockSourceView();
			if(currentSourceFileBeingViewed != filename)
			{
				// new file!!!
				String[] lines = FileCache.File(filename);
				SourceView.BeginUpdate();
				SourceView.Items.Clear();
				for(int i=1;i<=lines.Length;i++)
				{
					int addr = Flash.FindAddress(
						filename,
						i
					);
					
					// set the BG color as appropriate
					if(i == 1)
						MainForm.SourceView.ForeColor = ((addr & 0x10000) != 0) ? System.Drawing.Color.LightGreen : System.Drawing.Color.LightSalmon;

					SourceView.Items.Add(
						DecorateSourceLine(
							(i == lines.Length) || (Flash.FindAddress(filename,i+1) != addr), // only decorate if there's data on the line, or it's the last line (there may be data there)
							addr, 
							lines[i-1]
						)
					);
				}
				currentSourceFileBeingViewed = filename;
				SourceView.EndUpdate();
			}
			else
			{
				// new location in current file...
				String[] lines = FileCache.File(filename);
				SourceView.BeginUpdate();

				// remove old arrow
				if(currentLineBeingViewed > 0)
				{
					int addr = Flash.FindAddress(
						filename,
						currentLineBeingViewed
					);
					SourceView.Items[currentLineBeingViewed-1] = DecorateSourceLine(
						true, 
						addr, 
						lines[currentLineBeingViewed-1]
					);
				}

				// create new arrow
				if(lineNumber > 0)
				{
					int addr = Flash.FindAddress(
						filename,
						lineNumber
					);
					SourceView.Items[lineNumber-1] = DecorateSourceLine(
						true, 
						addr, 
						lines[lineNumber-1]
					);
				}

				SourceView.EndUpdate();
			}
			
			currentLineBeingViewed = lineNumber;
			SourceView.SelectedIndex = lineNumber-1;

			int topIndex = SourceView.SelectedIndex - (SourceView.Height / SourceView.ItemHeight) / 2;
			if(topIndex < 0)
				topIndex = 0;
			SourceView.TopIndex = topIndex;
			UnlockSourceView();
//			System.Diagnostics.Debugger.Log(0, "SrcView", "End\n");
		}


		/// <summary>
		/// Show a disassembly.  (used when no source file is present).
		/// </summary>
		public static void SourceViewShowDisassembly()
		{
//			System.Diagnostics.Debugger.Log(0, "SrcView", "Displayer = "+System.Threading.Thread.CurrentThread.Name+"\n");
//			System.Diagnostics.Debugger.Log(0, "SrcView", "Begin\n");
			LockSourceView();
			SourceView.BeginUpdate();
			SourceView.Items.Clear();
			MainForm.SourceView.ForeColor = Flash.A16 ? System.Drawing.Color.LightGreen : System.Drawing.Color.LightSalmon;
			int offset = 0;
			do
			{
				ushort addr = (ushort)(Cpu8052.Pc+offset);
				IInstruction i = InstructionInterpreter.FigureInstruction(
					Flash.GetByte((ushort)(addr+0), Flash.A16),
					Flash.GetByte((ushort)(addr+1), Flash.A16),
					Flash.GetByte((ushort)(addr+2), Flash.A16)
				);
				String line = "";
				int n;
				for(n=0;n<i.SizeInBytes;n++)
					line = line + Flash.GetByte((ushort)(addr+n), Flash.A16).ToString("X2") + " ";
				while(n<3)
				{
					line += "   ";
					n++;
				}
				line = line + "  " + addr.ToString("X4") + "   " + i.ToString(
					addr,
					Flash.GetByte((ushort)(addr+0), Flash.A16),
					Flash.GetByte((ushort)(addr+1), Flash.A16),
					Flash.GetByte((ushort)(addr+2), Flash.A16)
				);
				SourceView.Items.Add(
					DecorateSourceLine(true, addr+(Flash.A16?0x10000:0), line)
				);
				offset += i.SizeInBytes;
			}
			while( SourceView.Items.Count < (SourceView.Height / SourceView.ItemHeight) );

			currentSourceFileBeingViewed = null;
			SourceView.EndUpdate();
			
			SourceView.SelectedIndex = 0;

			int topIndex = SourceView.SelectedIndex - (SourceView.Height / SourceView.ItemHeight) / 2;
			if(topIndex < 0)
				topIndex = 0;
			SourceView.TopIndex = topIndex;
			UnlockSourceView();
//			System.Diagnostics.Debugger.Log(0, "SrcView", "End\n");
		}


		/// <summary>
		/// The one random number generator which everything should use.
		/// </summary>
		private static System.Random randy = new System.Random();

		private void toggleGlobalVariables_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			globalVariablesForm.Visible = item.Checked;
			if(globalVariablesForm.Visible)
				globalVariablesForm.CaptureState();
		}

		private void toggleExternalMemoryMenuItem_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			ExternalMemory.Visible = item.Checked;
			if(ExternalMemory.Visible)
				ExternalMemory.CaptureState();
		}

		private void toggleDRamMemoryMenuItem_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			DRamMemory.Visible = item.Checked;
			if(DRamMemory.Visible)
				DRamMemory.CaptureState();
		}

		private void toggleFileTreeBrowserWindow_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.MenuItem item = (System.Windows.Forms.MenuItem)sender;
			item.Checked = !item.Checked;
			FileTreeBrowser.Visible = item.Checked;
			if(FileTreeBrowser.Visible)
				FileTreeBrowser.CaptureState();
		}

		public static System.Windows.Forms.Label CurrentSegment
		{
			get
			{
				return theMainForm.currentSegment;
			}
		}

		public static ExternalMemoryForm ExternalMemory
		{
			get
			{
				return externalMemoryForm;
			}
		}

		public static DRamMemoryForm DRamMemory
		{
			get
			{
				return dramMemoryForm;
			}
		}

		public static FileTreeBrowserForm FileTreeBrowser
		{
			get
			{
				return fileTreeBrowserForm;
			}
		}

		

		/// <summary>
		/// The one random number generator which everything should use.
		/// </summary>
		public static System.Random Randy
		{
			get	{ return randy;	}
		}

	}
}
