using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for ProgramStatusWordForm.
	/// </summary>
	public class ProgramStatusWordForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.CheckBox regPswC;
		private System.Windows.Forms.CheckBox regPswP;
		private System.Windows.Forms.CheckBox regPswOv;
		private System.Windows.Forms.CheckBox regPswF0;
		private System.Windows.Forms.CheckBox regPswAc;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.RadioButton radioPswRegBank0;
		private System.Windows.Forms.RadioButton radioPswRegBank1;
		private System.Windows.Forms.RadioButton radioPswRegBank2;
		private System.Windows.Forms.RadioButton radioPswRegBank3;
		private System.Windows.Forms.TextBox regPsw;
		private System.Windows.Forms.CheckBox regPswGp;


		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;


		public ProgramStatusWordForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			CaptureState();
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		/// <summary>
		/// Ensure the closing this view only hides it.
		/// </summary>
		private void Form_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel = true;	// don't let it get closed!
			MainForm.ToggleProgramStatusWordMenuItem.Checked = !MainForm.ToggleProgramStatusWordMenuItem.Checked;
			Visible = MainForm.ToggleProgramStatusWordMenuItem.Checked;
		}


		/// <summary>
		/// Ensure the values on-screen reflect that values in memory.
		/// </summary>
		public void CaptureState()
		{
			bool isChecked;
			String[] lines = new String[1];
			System.Drawing.Color normal = System.Drawing.Color.White;
			System.Drawing.Color hilight = System.Drawing.Color.LightYellow;
			System.Drawing.Color normalCheck = System.Drawing.SystemColors.Control;

			lines[0] = Cpu8052.Psw.ToString("X2");
			if(this.regPsw.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regPsw.Lines = lines;
				this.regPsw.BackColor = hilight;
			}
			else
			{
				this.regPsw.BackColor = normal;
			}

			isChecked = ((Cpu8052.Psw & 0x01) != 0) ? true : false;
			if(this.regPswP.Checked != isChecked)
			{
				this.regPswP.Checked = isChecked;
				this.regPswP.BackColor = hilight;
			}
			else
			{
				this.regPswP.BackColor = normalCheck;
			}

			isChecked = ((Cpu8052.Psw & 0x04) != 0) ? true : false;
			if(this.regPswOv.Checked != isChecked)
			{
				this.regPswOv.Checked = isChecked;
				this.regPswOv.BackColor = hilight;
			}
			else
			{
				this.regPswOv.BackColor = normalCheck;
			}

			isChecked = ((Cpu8052.Psw & 0x20) != 0) ? true : false;
			if(this.regPswF0.Checked != isChecked)
			{
				this.regPswF0.Checked = isChecked;
				this.regPswF0.BackColor = hilight;
			}
			else
			{
				this.regPswF0.BackColor = normalCheck;
			}

			isChecked = ((Cpu8052.Psw & 0x40) != 0) ? true : false;
			if(this.regPswAc.Checked != isChecked)
			{
				this.regPswAc.Checked = isChecked;
				this.regPswAc.BackColor = hilight;
			}
			else
			{
				this.regPswAc.BackColor = normalCheck;
			}

			isChecked = ((Cpu8052.Psw & 0x02) != 0) ? true : false;
			if(this.regPswGp.Checked != isChecked)
			{
				this.regPswGp.Checked = isChecked;
				this.regPswGp.BackColor = hilight;
			}
			else
			{
				this.regPswGp.BackColor = normalCheck;
			}

			isChecked = ((Cpu8052.Psw & 0x80) != 0) ? true : false;
			if(this.regPswC.Checked != isChecked)
			{
				this.regPswC.Checked = isChecked;
				this.regPswC.BackColor = hilight;
			}
			else
			{
				this.regPswC.BackColor = normalCheck;
			}

			int mode = (Cpu8052.Psw>>3) & 3;
			bool changed = false;
			switch(mode)
			{
				case 0:
					if(!this.radioPswRegBank0.Checked)
						changed = true;
					break;
				case 1:
					if(!this.radioPswRegBank1.Checked)
						changed = true;
					break;
				case 2:
					if(!this.radioPswRegBank2.Checked)
						changed = true;
					break;
				case 3:
					if(!this.radioPswRegBank3.Checked)
						changed = true;
					break;
			}
			if(changed == true)
			{
				this.radioPswRegBank0.Checked = (mode == 0);
				this.radioPswRegBank0.BackColor = hilight;
				this.radioPswRegBank1.Checked = (mode == 1);
				this.radioPswRegBank1.BackColor = hilight;
				this.radioPswRegBank2.Checked = (mode == 2);
				this.radioPswRegBank2.BackColor = hilight;
				this.radioPswRegBank3.Checked = (mode == 3);
				this.radioPswRegBank3.BackColor = hilight;
			}
			else
			{
				this.radioPswRegBank0.BackColor = normalCheck;
				this.radioPswRegBank1.BackColor = normalCheck;
				this.radioPswRegBank2.BackColor = normalCheck;
				this.radioPswRegBank3.BackColor = normalCheck;
			}
		}


		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.regPsw = new System.Windows.Forms.TextBox();
			this.regPswC = new System.Windows.Forms.CheckBox();
			this.regPswP = new System.Windows.Forms.CheckBox();
			this.regPswOv = new System.Windows.Forms.CheckBox();
			this.regPswF0 = new System.Windows.Forms.CheckBox();
			this.regPswAc = new System.Windows.Forms.CheckBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.radioPswRegBank3 = new System.Windows.Forms.RadioButton();
			this.radioPswRegBank2 = new System.Windows.Forms.RadioButton();
			this.radioPswRegBank1 = new System.Windows.Forms.RadioButton();
			this.radioPswRegBank0 = new System.Windows.Forms.RadioButton();
			this.regPswGp = new System.Windows.Forms.CheckBox();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 24);
			this.label1.TabIndex = 15;
			this.label1.Text = "PCON";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regPsw
			// 
			this.regPsw.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regPsw.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regPsw.Location = new System.Drawing.Point(56, 8);
			this.regPsw.MaxLength = 8;
			this.regPsw.Name = "regPsw";
			this.regPsw.Size = new System.Drawing.Size(64, 20);
			this.regPsw.TabIndex = 14;
			this.regPsw.Text = "00000000";
			this.regPsw.WordWrap = false;
			// 
			// regPswC
			// 
			this.regPswC.Location = new System.Drawing.Point(16, 152);
			this.regPswC.Name = "regPswC";
			this.regPswC.Size = new System.Drawing.Size(208, 16);
			this.regPswC.TabIndex = 16;
			this.regPswC.Text = "PSW.7 - C - Carry";
			// 
			// regPswP
			// 
			this.regPswP.Location = new System.Drawing.Point(16, 32);
			this.regPswP.Name = "regPswP";
			this.regPswP.Size = new System.Drawing.Size(208, 16);
			this.regPswP.TabIndex = 17;
			this.regPswP.Text = "PSW.0 - P - Parity of Accumulator";
			// 
			// regPswOv
			// 
			this.regPswOv.Location = new System.Drawing.Point(16, 80);
			this.regPswOv.Name = "regPswOv";
			this.regPswOv.Size = new System.Drawing.Size(208, 16);
			this.regPswOv.TabIndex = 18;
			this.regPswOv.Text = "PSW.2 - OV - Overflow";
			// 
			// regPswF0
			// 
			this.regPswF0.Location = new System.Drawing.Point(16, 104);
			this.regPswF0.Name = "regPswF0";
			this.regPswF0.Size = new System.Drawing.Size(208, 16);
			this.regPswF0.TabIndex = 19;
			this.regPswF0.Text = "PSW.5 - F0 - User Flag 0";
			// 
			// regPswAc
			// 
			this.regPswAc.Location = new System.Drawing.Point(16, 128);
			this.regPswAc.Name = "regPswAc";
			this.regPswAc.Size = new System.Drawing.Size(208, 16);
			this.regPswAc.TabIndex = 20;
			this.regPswAc.Text = "PSW.6 - AC - Auxiliary Carry (BCD)";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.radioPswRegBank3,
																					this.radioPswRegBank2,
																					this.radioPswRegBank1,
																					this.radioPswRegBank0});
			this.groupBox1.Location = new System.Drawing.Point(16, 176);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(200, 80);
			this.groupBox1.TabIndex = 21;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Rn    Register Bank";
			// 
			// radioPswRegBank3
			// 
			this.radioPswRegBank3.Location = new System.Drawing.Point(104, 48);
			this.radioPswRegBank3.Name = "radioPswRegBank3";
			this.radioPswRegBank3.Size = new System.Drawing.Size(64, 16);
			this.radioPswRegBank3.TabIndex = 3;
			this.radioPswRegBank3.Text = "Bank 3";
			// 
			// radioPswRegBank2
			// 
			this.radioPswRegBank2.Location = new System.Drawing.Point(104, 24);
			this.radioPswRegBank2.Name = "radioPswRegBank2";
			this.radioPswRegBank2.Size = new System.Drawing.Size(64, 16);
			this.radioPswRegBank2.TabIndex = 2;
			this.radioPswRegBank2.Text = "Bank 2";
			// 
			// radioPswRegBank1
			// 
			this.radioPswRegBank1.Location = new System.Drawing.Point(16, 48);
			this.radioPswRegBank1.Name = "radioPswRegBank1";
			this.radioPswRegBank1.Size = new System.Drawing.Size(64, 16);
			this.radioPswRegBank1.TabIndex = 1;
			this.radioPswRegBank1.Text = "Bank 1";
			// 
			// radioPswRegBank0
			// 
			this.radioPswRegBank0.Location = new System.Drawing.Point(16, 24);
			this.radioPswRegBank0.Name = "radioPswRegBank0";
			this.radioPswRegBank0.Size = new System.Drawing.Size(64, 16);
			this.radioPswRegBank0.TabIndex = 0;
			this.radioPswRegBank0.Text = "Bank 0";
			// 
			// regPswGp
			// 
			this.regPswGp.Location = new System.Drawing.Point(16, 56);
			this.regPswGp.Name = "regPswGp";
			this.regPswGp.Size = new System.Drawing.Size(208, 16);
			this.regPswGp.TabIndex = 22;
			this.regPswGp.Text = "PSW.1 - GP - General Purpose";
			// 
			// ProgramStatusWordForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(226, 266);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.regPswGp,
																		  this.groupBox1,
																		  this.regPswAc,
																		  this.regPswF0,
																		  this.regPswOv,
																		  this.regPswP,
																		  this.regPswC,
																		  this.label1,
																		  this.regPsw});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.Name = "ProgramStatusWordForm";
			this.Text = "ProgramStatusWordForm";
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Form_Closing);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
	}
}
