using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for SerialPowerRegistersForm.
	/// </summary>
	public class SerialPowerRegistersForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox displayMode;
		private System.Windows.Forms.RadioButton displayBin;
		private System.Windows.Forms.RadioButton displayDec;
		private System.Windows.Forms.RadioButton displayHex;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox regScon;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.RadioButton SconMode0;
		private System.Windows.Forms.RadioButton SconMode1;
		private System.Windows.Forms.RadioButton SconMode2;
		private System.Windows.Forms.RadioButton SconMode3;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox regPcon;
		private System.Windows.Forms.CheckBox bitRi;
		private System.Windows.Forms.CheckBox bitTi;
		private System.Windows.Forms.CheckBox bitRb8;
		private System.Windows.Forms.CheckBox bitTb8;
		private System.Windows.Forms.CheckBox bitRen;
		private System.Windows.Forms.CheckBox bitIdl;
		private System.Windows.Forms.CheckBox bitPd;
		private System.Windows.Forms.CheckBox bitGf1;
		private System.Windows.Forms.CheckBox bitGf0;
		private System.Windows.Forms.CheckBox bitSmod;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox regSbuf;
		private System.Windows.Forms.CheckBox bitSm2;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public SerialPowerRegistersForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Ensure the closing this view only hides it.
		/// </summary>
		private void TimerCounterRegistersForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel = true;	// don't let it get closed!
			MainForm.ToggleSerialPowerRegs.Checked = !MainForm.ToggleSerialPowerRegs.Checked;
			Visible = MainForm.ToggleSerialPowerRegs.Checked;
		}


		/// <summary>
		/// Ensure the values on-screen reflect that values in memory.
		/// </summary>
		public void CaptureState()
		{
			bool isChecked;
			String[] lines = new String[1];
			System.Drawing.Color normal = System.Drawing.Color.White;
			System.Drawing.Color hilight = System.Drawing.Color.LightYellow;
			System.Drawing.Color normalCheck = System.Drawing.SystemColors.Control;

//			lines[0] = Cpu8052.Sbuf.ToString("X2");
			lines[0] = "00";	// can't read SBUF, or its' value is changed!!!
			if(this.regSbuf.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regSbuf.Lines = lines;
				this.regSbuf.BackColor = hilight;
			}
			else
			{
				this.regSbuf.BackColor = normal;
			}

			lines[0] = Cpu8052.Scon.ToString("X2");
			if(this.regScon.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regScon.Lines = lines;
				this.regScon.BackColor = hilight;
			}
			else
			{
				this.regScon.BackColor = normal;
			}
			
			lines[0] = Cpu8052.Pcon.ToString("X2");
			if(this.regPcon.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regPcon.Lines = lines;
				this.regPcon.BackColor = hilight;
			}
			else
			{
				this.regPcon.BackColor = normal;
			}
			
			isChecked = (Cpu8052.Pcon & 0x80) != 0;
			if(this.bitSmod.Checked != isChecked)
			{
				this.bitSmod.Checked = isChecked;
				this.bitSmod.BackColor = hilight;
			}
			else
			{
				this.bitSmod.BackColor = normalCheck;
			}
			
			isChecked = (Cpu8052.Pcon & 0x04) != 0;
			if(this.bitGf0.Checked != isChecked)
			{
				this.bitGf0.Checked = isChecked;
				this.bitGf0.BackColor = hilight;
			}
			else
			{
				this.bitGf0.BackColor = normalCheck;
			}
			
			isChecked = (Cpu8052.Pcon & 0x08) != 0;
			if(this.bitGf1.Checked != isChecked)
			{
				this.bitGf1.Checked = isChecked;
				this.bitGf1.BackColor = hilight;
			}
			else
			{
				this.bitGf1.BackColor = normalCheck;
			}

			isChecked = (Cpu8052.Pcon & 0x02) != 0;
			if(this.bitPd.Checked != isChecked)
			{
				this.bitPd.Checked = isChecked;
				this.bitPd.BackColor = hilight;
			}
			else
			{
				this.bitPd.BackColor = normalCheck;
			}

			isChecked = (Cpu8052.Pcon & 0x02) != 0;
			if(this.bitIdl.Checked != isChecked)
			{
				this.bitIdl.Checked = isChecked;
				this.bitIdl.BackColor = hilight;
			}
			else
			{
				this.bitIdl.BackColor = normalCheck;
			}
			
			isChecked = (Cpu8052.Scon & 0x20) != 0;
			if(this.bitSm2.Checked != isChecked)
			{
				this.bitSm2.Checked = isChecked;
				this.bitSm2.BackColor = hilight;
			}
			else
			{
				this.bitSm2.BackColor = normalCheck;
			}
			
			isChecked = (Cpu8052.Scon & 0x01) != 0;
			if(this.bitRi.Checked != isChecked)
			{
				this.bitRi.Checked = isChecked;
				this.bitRi.BackColor = hilight;
			}
			else
			{
				this.bitRi.BackColor = normalCheck;
			}
			
			isChecked = (Cpu8052.Scon & 0x02) != 0;
			if(this.bitTi.Checked != isChecked)
			{
				this.bitTi.Checked = isChecked;
				this.bitTi.BackColor = hilight;
			}
			else
			{
				this.bitTi.BackColor = normalCheck;
			}

			isChecked = (Cpu8052.Scon & 0x10) != 0;
			if(this.bitRen.Checked != isChecked)
			{
				this.bitRen.Checked = isChecked;
				this.bitRen.BackColor = hilight;
			}
			else
			{
				this.bitRen.BackColor = normalCheck;
			}

			isChecked = (Cpu8052.Scon & 0x04) != 0;
			if(this.bitRb8.Checked != isChecked)
			{
				this.bitRb8.Checked = isChecked;
				this.bitRb8.BackColor = hilight;
			}
			else
			{
				this.bitRb8.BackColor = normalCheck;
			}

			isChecked = (Cpu8052.Scon & 0x08) != 0;
			if(this.bitTb8.Checked != isChecked)
			{
				this.bitTb8.Checked = isChecked;
				this.bitTb8.BackColor = hilight;
			}
			else
			{
				this.bitTb8.BackColor = normalCheck;
			}

			int mode = (Cpu8052.Scon>>6) & 3;
			bool changed = false;
			switch(mode)
			{
				case 0:
					if(!this.SconMode0.Checked)
						changed = true;
					break;
				case 1:
					if(!this.SconMode1.Checked)
						changed = true;
					break;
				case 2:
					if(!this.SconMode2.Checked)
						changed = true;
					break;
				case 3:
					if(!this.SconMode3.Checked)
						changed = true;
					break;
			}
			if(changed == true)
			{
				this.SconMode0.Checked = (mode == 0);
				this.SconMode0.BackColor = hilight;
				this.SconMode1.Checked = (mode == 1);
				this.SconMode1.BackColor = hilight;
				this.SconMode2.Checked = (mode == 2);
				this.SconMode2.BackColor = hilight;
				this.SconMode3.Checked = (mode == 3);
				this.SconMode3.BackColor = hilight;
			}
			else
			{
				this.SconMode0.BackColor = normalCheck;
				this.SconMode1.BackColor = normalCheck;
				this.SconMode2.BackColor = normalCheck;
				this.SconMode3.BackColor = normalCheck;
			}
		}
		
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.bitRi = new System.Windows.Forms.CheckBox();
			this.bitTi = new System.Windows.Forms.CheckBox();
			this.bitRb8 = new System.Windows.Forms.CheckBox();
			this.bitTb8 = new System.Windows.Forms.CheckBox();
			this.bitRen = new System.Windows.Forms.CheckBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.SconMode3 = new System.Windows.Forms.RadioButton();
			this.SconMode2 = new System.Windows.Forms.RadioButton();
			this.SconMode1 = new System.Windows.Forms.RadioButton();
			this.SconMode0 = new System.Windows.Forms.RadioButton();
			this.label4 = new System.Windows.Forms.Label();
			this.regScon = new System.Windows.Forms.TextBox();
			this.displayMode = new System.Windows.Forms.GroupBox();
			this.displayBin = new System.Windows.Forms.RadioButton();
			this.displayDec = new System.Windows.Forms.RadioButton();
			this.displayHex = new System.Windows.Forms.RadioButton();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.bitIdl = new System.Windows.Forms.CheckBox();
			this.bitPd = new System.Windows.Forms.CheckBox();
			this.bitGf1 = new System.Windows.Forms.CheckBox();
			this.bitGf0 = new System.Windows.Forms.CheckBox();
			this.bitSmod = new System.Windows.Forms.CheckBox();
			this.label1 = new System.Windows.Forms.Label();
			this.regPcon = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.regSbuf = new System.Windows.Forms.TextBox();
			this.bitSm2 = new System.Windows.Forms.CheckBox();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.displayMode.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.bitSm2,
																					this.bitRi,
																					this.bitTi,
																					this.bitRb8,
																					this.bitTb8,
																					this.bitRen,
																					this.groupBox2,
																					this.label4,
																					this.regScon});
			this.groupBox1.Location = new System.Drawing.Point(240, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(160, 272);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Serial Port";
			// 
			// bitRi
			// 
			this.bitRi.Location = new System.Drawing.Point(8, 248);
			this.bitRi.Name = "bitRi";
			this.bitRi.Size = new System.Drawing.Size(144, 16);
			this.bitRi.TabIndex = 17;
			this.bitRi.Text = "RI - Recieve Interrupt";
			// 
			// bitTi
			// 
			this.bitTi.Location = new System.Drawing.Point(8, 224);
			this.bitTi.Name = "bitTi";
			this.bitTi.Size = new System.Drawing.Size(144, 16);
			this.bitTi.TabIndex = 16;
			this.bitTi.Text = "TI - Transmit Interrupt";
			// 
			// bitRb8
			// 
			this.bitRb8.Location = new System.Drawing.Point(8, 200);
			this.bitRb8.Name = "bitRb8";
			this.bitRb8.Size = new System.Drawing.Size(144, 16);
			this.bitRb8.TabIndex = 15;
			this.bitRb8.Text = "RB8 - Recieved Bit 8";
			// 
			// bitTb8
			// 
			this.bitTb8.Location = new System.Drawing.Point(8, 176);
			this.bitTb8.Name = "bitTb8";
			this.bitTb8.Size = new System.Drawing.Size(144, 16);
			this.bitTb8.TabIndex = 14;
			this.bitTb8.Text = "TB8 - Transmitted Bit 8";
			// 
			// bitRen
			// 
			this.bitRen.Location = new System.Drawing.Point(8, 152);
			this.bitRen.Name = "bitRen";
			this.bitRen.Size = new System.Drawing.Size(144, 16);
			this.bitRen.TabIndex = 13;
			this.bitRen.Text = "REN - Recieve Enable";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.SconMode3,
																					this.SconMode2,
																					this.SconMode1,
																					this.SconMode0});
			this.groupBox2.Location = new System.Drawing.Point(24, 48);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(112, 72);
			this.groupBox2.TabIndex = 12;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Serial Port Mode";
			// 
			// SconMode3
			// 
			this.SconMode3.Location = new System.Drawing.Point(72, 48);
			this.SconMode3.Name = "SconMode3";
			this.SconMode3.Size = new System.Drawing.Size(32, 16);
			this.SconMode3.TabIndex = 3;
			this.SconMode3.Text = "3";
			// 
			// SconMode2
			// 
			this.SconMode2.Location = new System.Drawing.Point(72, 24);
			this.SconMode2.Name = "SconMode2";
			this.SconMode2.Size = new System.Drawing.Size(32, 16);
			this.SconMode2.TabIndex = 2;
			this.SconMode2.Text = "2";
			// 
			// SconMode1
			// 
			this.SconMode1.Location = new System.Drawing.Point(16, 48);
			this.SconMode1.Name = "SconMode1";
			this.SconMode1.Size = new System.Drawing.Size(32, 16);
			this.SconMode1.TabIndex = 1;
			this.SconMode1.Text = "1";
			// 
			// SconMode0
			// 
			this.SconMode0.Location = new System.Drawing.Point(16, 24);
			this.SconMode0.Name = "SconMode0";
			this.SconMode0.Size = new System.Drawing.Size(32, 16);
			this.SconMode0.TabIndex = 0;
			this.SconMode0.Text = "0";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 16);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(40, 24);
			this.label4.TabIndex = 11;
			this.label4.Text = "SCON";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regScon
			// 
			this.regScon.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regScon.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regScon.Location = new System.Drawing.Point(56, 16);
			this.regScon.MaxLength = 8;
			this.regScon.Name = "regScon";
			this.regScon.Size = new System.Drawing.Size(64, 20);
			this.regScon.TabIndex = 10;
			this.regScon.Text = "00000000";
			this.regScon.WordWrap = false;
			// 
			// displayMode
			// 
			this.displayMode.Controls.AddRange(new System.Windows.Forms.Control[] {
																					  this.displayBin,
																					  this.displayDec,
																					  this.displayHex});
			this.displayMode.Location = new System.Drawing.Point(8, 8);
			this.displayMode.Name = "displayMode";
			this.displayMode.Size = new System.Drawing.Size(152, 40);
			this.displayMode.TabIndex = 17;
			this.displayMode.TabStop = false;
			this.displayMode.Text = "Display";
			// 
			// displayBin
			// 
			this.displayBin.Location = new System.Drawing.Point(104, 16);
			this.displayBin.Name = "displayBin";
			this.displayBin.Size = new System.Drawing.Size(40, 16);
			this.displayBin.TabIndex = 2;
			this.displayBin.TabStop = true;
			this.displayBin.Text = "Bin";
			// 
			// displayDec
			// 
			this.displayDec.Location = new System.Drawing.Point(56, 16);
			this.displayDec.Name = "displayDec";
			this.displayDec.Size = new System.Drawing.Size(48, 16);
			this.displayDec.TabIndex = 1;
			this.displayDec.TabStop = true;
			this.displayDec.Text = "Dec";
			// 
			// displayHex
			// 
			this.displayHex.Checked = true;
			this.displayHex.Location = new System.Drawing.Point(8, 16);
			this.displayHex.Name = "displayHex";
			this.displayHex.Size = new System.Drawing.Size(48, 16);
			this.displayHex.TabIndex = 0;
			this.displayHex.TabStop = true;
			this.displayHex.Text = "Hex";
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.bitIdl,
																					this.bitPd,
																					this.bitGf1,
																					this.bitGf0,
																					this.bitSmod,
																					this.label1,
																					this.regPcon});
			this.groupBox3.Location = new System.Drawing.Point(8, 56);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(216, 184);
			this.groupBox3.TabIndex = 18;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "Power Mode Control";
			// 
			// bitIdl
			// 
			this.bitIdl.Location = new System.Drawing.Point(16, 160);
			this.bitIdl.Name = "bitIdl";
			this.bitIdl.Size = new System.Drawing.Size(192, 16);
			this.bitIdl.TabIndex = 18;
			this.bitIdl.Text = "IDL - Idle Mode";
			// 
			// bitPd
			// 
			this.bitPd.Location = new System.Drawing.Point(16, 136);
			this.bitPd.Name = "bitPd";
			this.bitPd.Size = new System.Drawing.Size(192, 16);
			this.bitPd.TabIndex = 17;
			this.bitPd.Text = "PD - Power Down";
			// 
			// bitGf1
			// 
			this.bitGf1.Location = new System.Drawing.Point(16, 104);
			this.bitGf1.Name = "bitGf1";
			this.bitGf1.Size = new System.Drawing.Size(192, 16);
			this.bitGf1.TabIndex = 16;
			this.bitGf1.Text = "GF1 - General Purpose Flag 1";
			// 
			// bitGf0
			// 
			this.bitGf0.Location = new System.Drawing.Point(16, 80);
			this.bitGf0.Name = "bitGf0";
			this.bitGf0.Size = new System.Drawing.Size(192, 16);
			this.bitGf0.TabIndex = 15;
			this.bitGf0.Text = "GF0 - General Purpose Flag 0";
			// 
			// bitSmod
			// 
			this.bitSmod.Location = new System.Drawing.Point(16, 48);
			this.bitSmod.Name = "bitSmod";
			this.bitSmod.Size = new System.Drawing.Size(192, 16);
			this.bitSmod.TabIndex = 14;
			this.bitSmod.Text = "SMOD - Serial Baud Rate Modify";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 24);
			this.label1.TabIndex = 13;
			this.label1.Text = "PCON";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regPcon
			// 
			this.regPcon.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regPcon.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regPcon.Location = new System.Drawing.Point(56, 16);
			this.regPcon.MaxLength = 8;
			this.regPcon.Name = "regPcon";
			this.regPcon.Size = new System.Drawing.Size(64, 20);
			this.regPcon.TabIndex = 12;
			this.regPcon.Text = "00000000";
			this.regPcon.WordWrap = false;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 256);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(40, 24);
			this.label2.TabIndex = 20;
			this.label2.Text = "SBUF";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regSbuf
			// 
			this.regSbuf.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regSbuf.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regSbuf.Location = new System.Drawing.Point(64, 256);
			this.regSbuf.MaxLength = 8;
			this.regSbuf.Name = "regSbuf";
			this.regSbuf.Size = new System.Drawing.Size(64, 20);
			this.regSbuf.TabIndex = 19;
			this.regSbuf.Text = "00000000";
			this.regSbuf.WordWrap = false;
			// 
			// bitSm2
			// 
			this.bitSm2.Location = new System.Drawing.Point(8, 128);
			this.bitSm2.Name = "bitSm2";
			this.bitSm2.Size = new System.Drawing.Size(144, 16);
			this.bitSm2.TabIndex = 18;
			this.bitSm2.Text = "SM2 - Multiprocessor";
			// 
			// SerialPowerRegistersForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(410, 290);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.label2,
																		  this.regSbuf,
																		  this.groupBox3,
																		  this.displayMode,
																		  this.groupBox1});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.Name = "SerialPowerRegistersForm";
			this.Text = "Serial Port & Power Control Registers";
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.TimerCounterRegistersForm_Closing);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.displayMode.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
	}
}
