using System;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for SymbolObject.
	/// </summary>
	public class SymbolObject
	{
		public SymbolObject(String segName, String symbolName, ushort symbolAddress, ushort symbolBytes)
		{
			segmentName = segName;
			name = symbolName;
			address = symbolAddress;
			sizeInBytes = symbolBytes;
		}
	
		public override String ToString()
		{
			String str = segmentName + ":" + address.ToString("X4") + " " + name + " = ";
			
			if(String.Compare(segmentName, "XSEG", true) == 0)
			{
				if(XRam.IsLegalAddress(address))
				{
					switch(sizeInBytes)
					{
						case 1:	str += XRam.ReadByte(address).ToString("X2");	break;
						case 2:	str += XRam.ReadWord(address).ToString("X4");	break;
						case 4:	str += XRam.ReadLong(address).ToString("X8");	break;
						default:	
							break;
					}
				}
				else
				{
					str += "(Uninitialized DRAM Controller Page)";
				}
			}
			else if(String.Compare(segmentName, "DSEG", true) == 0)
			{
				switch(sizeInBytes)
				{
					case 1:	str += Cpu8052.GetInternalRam(address).ToString("X2");	break;
					case 2:	
						{
							ushort val = 
								(ushort)(
									Cpu8052.GetInternalRam(address+0) + 
									Cpu8052.GetInternalRam(address+1) * 256
								);
							str += val.ToString("X4");		
						}
						break;
					case 4:
						{
							ulong val = 
								( (ulong)Cpu8052.GetInternalRam(address+0)) + 
								(((ulong)Cpu8052.GetInternalRam(address+1)) << 8) +
								(((ulong)Cpu8052.GetInternalRam(address+2)) << 16) +
								(((ulong)Cpu8052.GetInternalRam(address+3)) << 24);
							str += val.ToString("X8");
						}
						break;
					default:	
						break;
				}
			}
			else if(String.Compare(segmentName, "CSEG", true) == 0)
			{
/*
				switch(sizeInBytes)
				{
					case 1:	str += Flash.GetByte(address, Flash.A16).ToString("X2");	break;
					case 2:	str += Flash.GetWord(address, Flash.A16).ToString("X4");	break;
					case 4:	str += Flash.GetLong(address, Flash.A16).ToString("X8");	break;
					default:	
						break;
				}
*/	
				return null;
			}
			else if(String.Compare(segmentName, "BSEG", true) == 0)
			{
				str += (Cpu8052.GetBit((byte)address) == true) ? "TRUE" : "false";
			}
			else 
			{
				// unknown symbol type...
			}
			
			// only hilite the string if it has changed.
			if(String.Compare(str, wasString) == 0)
			{
				// same!
				return "   " + str;
			}
			else
			{
				wasString = str;
				return "***" + str;
			}
		}	
		
		/// <summary>
		/// Returns TRUE if this symbol goes by the name which was offered.
		/// </summary>
		public bool IsSymbol(String _name)
		{
			return String.Compare(_name, name, true) == 0;
		}
		
		public ushort Address
		{
			get {return address;}
		}
		
		public ushort SizeInBytes
		{
			get {return sizeInBytes;}
		}
		
		String segmentName;
		
		String name;
		ushort address;
		ushort sizeInBytes;
		
		String wasString;	// the string, as it was seen last time it was generated.
	}
}
