using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for TerminalWindowForm.
	/// </summary>
	public class TerminalWindowForm : System.Windows.Forms.Form
	{


		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public TerminalWindowForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Ensure the closing this view only hides it.
		/// </summary>
		private void Form_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel = true;	// don't let it get closed!
			MainForm.ToggleTerminalWindow.Checked = !MainForm.ToggleTerminalWindow.Checked;
			Visible = MainForm.ToggleTerminalWindow.Checked;
		}

		/// <summary>
		/// Ensure the values on-screen reflect that values in memory.
		/// </summary>
		public void CaptureState()
		{
			// do nothing...
//			terminalView.Items = (String[])TransmittedLines.Clone();

			terminalView.BeginUpdate();
			terminalView.Items.Clear();
			foreach(String line in TransmittedLines)
				if(line == null)
					terminalView.Items.Add("");
				else
					terminalView.Items.Add(line);
			terminalView.EndUpdate();
			
			System.Drawing.Point p = new System.Drawing.Point(cursorX,cursorY);
			int i = cursorY - (terminalView.Height / terminalView.ItemHeight) / 2;
			if(i < 0)
				i = 0;
			terminalView.TopIndex = i;
		}

		/// <summary>
		/// Erase all text in terminal view, and reset cursor to 0,0
		/// </summary>
		public void Clear()
		{
			cursorX = 0;
			cursorY = 0;
			transmittedLines = new String[0];
			CaptureState();
		}


		/// <summary>
		/// Array of lines of text which have been transmitted.
		/// </summary>
		private static String[] transmittedLines = new String[0];

		
		/// <summary>
		/// keeps track of the current X coordinate.
		/// </summary>
		private static int cursorX = 0;
		private System.Windows.Forms.ListBox terminalView;
		private System.Windows.Forms.Button btnCapture;


		/// <summary>
		/// keeps track of the current Y coordinate.
		/// </summary>
		private static int cursorY = 0;

		
		/// <summary>
		/// Fetch the files which represent what has been transmitted so far...
		/// </summary>
		public static String[] TransmittedLines
		{
			get	{	return transmittedLines;	}
		}


		/// <summary>
		/// Display a character in the terminal view
		/// </summary>
		public void DisplayCharacter(char c)
		{
	//		System.Diagnostics.Debugger.Log(0, "Simulation", "**CHAR\n");
			if(c == 0x0d)
				cursorX = 0;
			else if(c == 0x0a)
				cursorY++;
			else
			{
				String[] newLines = transmittedLines;
				
				// ensure enough lines exist.
				if(newLines.Length <= cursorY)
				{
					string[] temp = new string [cursorY+1];
					for(int n=0;n<newLines.Length;n++)
						temp[n] = newLines[n];
					temp[cursorY] = new String(' ', cursorX+1);
					newLines = temp;
				}

				// pad line as needed.
				while(newLines[cursorY].Length <= cursorX)
					newLines[cursorY] += ' ';
				
				// change the character in the string, as needed.
				char[] characters = new char[newLines[cursorY].Length];
				int i = 0;
				foreach(char ch in newLines[cursorY])
					characters[i++] = ch;
				characters[cursorX] = c;
				newLines[cursorY] = "";
				foreach(char ch in characters)
					newLines[cursorY] += ch;
				
				transmittedLines = newLines;
				cursorX++;

//				CaptureState();
			}
	//		System.Diagnostics.Debugger.Log(0, "Simulation", "..DONE\n");
		}


		/// <summary>
		/// The buffer of characters which th euser has typed, and are waiting 
		/// for the CPU to gobble up through the Recieve port.
		/// </summary>
		private System.Collections.ArrayList recievedChars = new System.Collections.ArrayList();	// char

		/// <summary>
		/// Returns TRUE if the user has typed some characters into the terminal window.
		/// </summary>
		public bool HasCharacter()
		{
			return (recievedChars.Count != 0);
		}
		
		
		/// <summary>
		/// Get the next character typed by the user, into the terminal window.
		/// </summary>
		public char GetCharacter()
		{
			char c = (char)recievedChars[0];
			recievedChars.RemoveAt(0);
			return c;
		}
		
		
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.terminalView = new System.Windows.Forms.ListBox();
			this.btnCapture = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// terminalView
			// 
			this.terminalView.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.terminalView.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.terminalView.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.terminalView.HorizontalScrollbar = true;
			this.terminalView.ItemHeight = 14;
			this.terminalView.Location = new System.Drawing.Point(8, 40);
			this.terminalView.Name = "terminalView";
			this.terminalView.ScrollAlwaysVisible = true;
			this.terminalView.Size = new System.Drawing.Size(496, 112);
			this.terminalView.TabIndex = 0;
			this.terminalView.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.terminalView_KeyPressed);
			// 
			// btnCapture
			// 
			this.btnCapture.Location = new System.Drawing.Point(8, 8);
			this.btnCapture.Name = "btnCapture";
			this.btnCapture.Size = new System.Drawing.Size(112, 24);
			this.btnCapture.TabIndex = 1;
			this.btnCapture.Text = "Capture";
			this.btnCapture.Click += new System.EventHandler(this.btnCapture_Click);
			// 
			// TerminalWindowForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(512, 160);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnCapture,
																		  this.terminalView});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.Name = "TerminalWindowForm";
			this.Text = "TerminalWindowForm";
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Form_Closing);
			this.ResumeLayout(false);

		}
		#endregion

		private void terminalView_KeyPressed(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			recievedChars.Add(e.KeyChar);
			e.Handled = true;
		}

		private void btnCapture_Click(object sender, System.EventArgs e)
		{
			CaptureState();
		}
	}
}
