using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace _8052Sim
{
	/// <summary>
	/// Summary description for TimerCounterRegistersForm.
	/// </summary>
	public class TimerCounterRegistersForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.GroupBox displayMode;
		private System.Windows.Forms.RadioButton displayBin;
		private System.Windows.Forms.RadioButton displayDec;
		private System.Windows.Forms.RadioButton displayHex;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.GroupBox controlRegs;
		private System.Windows.Forms.TextBox regTcon;
		private System.Windows.Forms.GroupBox groupBox4;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.CheckBox regIe1;
		private System.Windows.Forms.RadioButton regIt0False;
		private System.Windows.Forms.RadioButton regIt0True;
		private System.Windows.Forms.RadioButton regIt1False;
		private System.Windows.Forms.RadioButton regIt1True;
		private System.Windows.Forms.CheckBox regIe0;
		private System.Windows.Forms.GroupBox groupBox5;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox regTmod;
		private System.Windows.Forms.GroupBox groupBox6;
		private System.Windows.Forms.GroupBox groupBox7;
		private System.Windows.Forms.GroupBox groupBox8;
		private System.Windows.Forms.CheckBox Gate0;
		private System.Windows.Forms.RadioButton radioCounter0;
		private System.Windows.Forms.RadioButton radioTimer0;
		private System.Windows.Forms.RadioButton radioMode10;
		private System.Windows.Forms.RadioButton radioMode00;
		private System.Windows.Forms.RadioButton radioMode30;
		private System.Windows.Forms.RadioButton radioMode20;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.RadioButton radioTimer1;
		private System.Windows.Forms.RadioButton radioCounter1;
		private System.Windows.Forms.CheckBox Gate1;
		private System.Windows.Forms.GroupBox groupBox9;
		private System.Windows.Forms.RadioButton radioMode31;
		private System.Windows.Forms.RadioButton radioMode21;
		private System.Windows.Forms.RadioButton radioMode11;
		private System.Windows.Forms.RadioButton radioMode01;
		private System.Windows.Forms.CheckBox t0Overflow;
		private System.Windows.Forms.CheckBox t0Running;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox regTl0;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox regTh0;
		private System.Windows.Forms.CheckBox t1Overflow;
		private System.Windows.Forms.CheckBox t1Running;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox regTl1;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.TextBox regTh1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public TimerCounterRegistersForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			CaptureState();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		
		/// <summary>
		/// Ensure the closing this view only hides it.
		/// </summary>
		private void TimerCounterRegistersForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel = true;	// don't let it get closed!
			MainForm.ToggleTimerCounterRegs.Checked = !MainForm.ToggleTimerCounterRegs.Checked;
			Visible = MainForm.ToggleTimerCounterRegs.Checked;
		}


		/// <summary>
		/// Ensure the values on-screen reflect that values in memory.
		/// </summary>
		public void CaptureState()
		{
			bool isChecked;
			String[] lines = new String[1];
			System.Drawing.Color normal = System.Drawing.Color.White;
			System.Drawing.Color hilight = System.Drawing.Color.LightYellow;
			System.Drawing.Color normalCheck = System.Drawing.SystemColors.Control;

			lines[0] = Cpu8052.Tmod.ToString("X2");
			if(this.regTmod.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regTmod.Lines = lines;
				this.regTmod.BackColor = hilight;
			}
			else
			{
				this.regTmod.BackColor = normal;
			}
			
			lines[0] = Cpu8052.Tcon.ToString("X2");
			if(this.regTcon.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regTcon.Lines = lines;
				this.regTcon.BackColor = hilight;
			}
			else
			{
				this.regTcon.BackColor = normal;
			}

			lines[0] = Cpu8052.Th0.ToString("X2");
			if(this.regTh0.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regTh0.Lines = lines;
				this.regTh0.BackColor = hilight;
			}
			else
			{
				this.regTh0.BackColor = normal;
			}

			lines[0] = Cpu8052.Th1.ToString("X2");
			if(this.regTh1.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regTh1.Lines = lines;
				this.regTh1.BackColor = hilight;
			}
			else
			{
				this.regTh1.BackColor = normal;
			}

			lines[0] = Cpu8052.Tl0.ToString("X2");
			if(this.regTl0.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regTl0.Lines = lines;
				this.regTl0.BackColor = hilight;
			}
			else
			{
				this.regTl0.BackColor = normal;
			}

			lines[0] = Cpu8052.Tl1.ToString("X2");
			if(this.regTl1.Lines[0].CompareTo(lines[0])!=0)
			{
				this.regTl1.Lines = lines;
				this.regTl1.BackColor = hilight;
			}
			else
			{
				this.regTl1.BackColor = normal;
			}
			
			isChecked = ((Cpu8052.Tmod & 0x08) != 0) ? true : false;
			if(this.Gate0.Checked != isChecked)
			{
				Gate0.Checked = isChecked;
				this.Gate0.BackColor = hilight;
			}
			else
			{
				this.Gate0.BackColor = normalCheck;
			}

			isChecked = ((Cpu8052.Tmod & 0x80) != 0) ? true : false;
			if(this.Gate1.Checked != isChecked)
			{
				Gate1.Checked = isChecked;
				this.Gate1.BackColor = hilight;
			}
			else
			{
				this.Gate1.BackColor = normalCheck;
			}
			
			isChecked = ((Cpu8052.Tcon & 0x04) != 0) ? true : false;
			if(this.t0Running.Checked != isChecked)
			{
				this.t0Running.Checked = isChecked;
				this.t0Running.BackColor = hilight;
			}
			else
			{
				this.t0Running.BackColor = normalCheck;
			}
			
			isChecked = ((Cpu8052.Tcon & 0x40) != 0) ? true : false;
			if(this.t1Running.Checked != isChecked)
			{
				this.t1Running.Checked = isChecked;
				this.t1Running.BackColor = hilight;
			}
			else
			{
				this.t1Running.BackColor = normalCheck;
			}
			
			isChecked = ((Cpu8052.Tcon & 0x20) != 0) ? true : false;
			if(this.t0Overflow.Checked != isChecked)
			{
				this.t0Overflow.Checked = isChecked;
				this.t0Overflow.BackColor = hilight;
			}
			else
			{
				this.t0Overflow.BackColor = normalCheck;
			}
			
			isChecked = ((Cpu8052.Tcon & 0x80) != 0) ? true : false;
			if(this.t1Overflow.Checked != isChecked)
			{
				this.t1Overflow.Checked = isChecked;
				this.t1Overflow.BackColor = hilight;
			}
			else
			{
				this.t1Overflow.BackColor = normalCheck;
			}
			
			isChecked = ((Cpu8052.Tmod & 0x04) != 0) ? true : false;
			if(this.radioCounter0.Checked != isChecked)
			{
				this.radioCounter0.Checked = isChecked;
				this.radioCounter0.BackColor = hilight;
				this.radioTimer0.Checked = !isChecked;
				this.radioTimer0.BackColor = hilight;
			}
			else
			{
				this.radioCounter0.BackColor = normalCheck;
				this.radioTimer0.BackColor = normalCheck;
			}

			isChecked = ((Cpu8052.Tmod & 0x40) != 0) ? true : false;
			if(this.radioCounter1.Checked != isChecked)
			{
				this.radioCounter1.Checked = isChecked;
				this.radioCounter1.BackColor = hilight;
				this.radioTimer1.Checked = !isChecked;
				this.radioTimer1.BackColor = hilight;
			}
			else
			{
				this.radioCounter1.BackColor = normalCheck;
				this.radioTimer1.BackColor = normalCheck;
			}
			
			int mode = Cpu8052.Tmod & 3;
			bool changed = false;
			switch(mode)
			{
				case 0:
					if(!this.radioMode00.Checked)
						changed = true;
					break;
				case 1:
					if(!this.radioMode10.Checked)
						changed = true;
					break;
				case 2:
					if(!this.radioMode20.Checked)
						changed = true;
					break;
				case 3:
					if(!this.radioMode30.Checked)
						changed = true;
					break;
			}
			if(changed == true)
			{
				this.radioMode00.Checked = (mode == 0);
				this.radioMode00.BackColor = hilight;
				this.radioMode10.Checked = (mode == 1);
				this.radioMode10.BackColor = hilight;
				this.radioMode20.Checked = (mode == 2);
				this.radioMode20.BackColor = hilight;
				this.radioMode30.Checked = (mode == 3);
				this.radioMode30.BackColor = hilight;
			}
			else
			{
				this.radioMode00.BackColor = normalCheck;
				this.radioMode10.BackColor = normalCheck;
				this.radioMode20.BackColor = normalCheck;
				this.radioMode30.BackColor = normalCheck;
			}

			mode = (Cpu8052.Tmod>>4) & 3;
			changed = false;
			switch(mode)
			{
				case 0:
					if(!this.radioMode01.Checked)
						changed = true;
					break;
				case 1:
					if(!this.radioMode11.Checked)
						changed = true;
					break;
				case 2:
					if(!this.radioMode21.Checked)
						changed = true;
					break;
				case 3:
					if(!this.radioMode31.Checked)
						changed = true;
					break;
			}
			if(changed == true)
			{
				this.radioMode01.Checked = (mode == 0);
				this.radioMode01.BackColor = hilight;
				this.radioMode11.Checked = (mode == 1);
				this.radioMode11.BackColor = hilight;
				this.radioMode21.Checked = (mode == 2);
				this.radioMode21.BackColor = hilight;
				this.radioMode31.Checked = (mode == 3);
				this.radioMode31.BackColor = hilight;
			}
			else
			{
				this.radioMode01.BackColor = normalCheck;
				this.radioMode11.BackColor = normalCheck;
				this.radioMode21.BackColor = normalCheck;
				this.radioMode31.BackColor = normalCheck;
			}

			isChecked = ((Cpu8052.Tcon & 0x08) != 0) ? true : false;
			if(this.regIe0.Checked != isChecked)
			{
				this.regIe0.Checked = isChecked;
				this.regIe0.BackColor = hilight;
			}
			else
			{
				this.regIe0.BackColor = normalCheck;
			}
			
			isChecked = ((Cpu8052.Tcon & 0x02) != 0) ? true : false;
			if(this.regIe1.Checked != isChecked)
			{
				this.regIe1.Checked = isChecked;
				this.regIe1.BackColor = hilight;
			}
			else
			{
				this.regIe1.BackColor = normalCheck;
			}
			
			isChecked = ((Cpu8052.Tcon & 0x01) != 0) ? true : false;
			if(this.regIt0True.Checked != isChecked)
			{
				this.regIt0True.Checked = isChecked;
				this.regIt0True.BackColor = hilight;
				this.regIt0False.Checked = !isChecked;
				this.regIt0False.BackColor = hilight;
			}
			else
			{
				this.regIt0True.BackColor = normalCheck;
				this.regIt0False.BackColor = normalCheck;
			}

			isChecked = ((Cpu8052.Tcon & 0x04) != 0) ? true : false;
			if(this.regIt1True.Checked != isChecked)
			{
				this.regIt1True.Checked = isChecked;
				this.regIt1True.BackColor = hilight;
				this.regIt1False.Checked = !isChecked;
				this.regIt1False.BackColor = hilight;
			}
			else
			{
				this.regIt1True.BackColor = normalCheck;
				this.regIt1False.BackColor = normalCheck;
			}
		}
		
		
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.displayMode = new System.Windows.Forms.GroupBox();
			this.displayBin = new System.Windows.Forms.RadioButton();
			this.displayDec = new System.Windows.Forms.RadioButton();
			this.displayHex = new System.Windows.Forms.RadioButton();
			this.controlRegs = new System.Windows.Forms.GroupBox();
			this.regIe0 = new System.Windows.Forms.CheckBox();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.regIt1False = new System.Windows.Forms.RadioButton();
			this.regIt1True = new System.Windows.Forms.RadioButton();
			this.groupBox4 = new System.Windows.Forms.GroupBox();
			this.regIt0False = new System.Windows.Forms.RadioButton();
			this.regIt0True = new System.Windows.Forms.RadioButton();
			this.regIe1 = new System.Windows.Forms.CheckBox();
			this.label3 = new System.Windows.Forms.Label();
			this.regTcon = new System.Windows.Forms.TextBox();
			this.groupBox5 = new System.Windows.Forms.GroupBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.radioTimer1 = new System.Windows.Forms.RadioButton();
			this.radioCounter1 = new System.Windows.Forms.RadioButton();
			this.Gate1 = new System.Windows.Forms.CheckBox();
			this.groupBox9 = new System.Windows.Forms.GroupBox();
			this.radioMode31 = new System.Windows.Forms.RadioButton();
			this.radioMode21 = new System.Windows.Forms.RadioButton();
			this.radioMode11 = new System.Windows.Forms.RadioButton();
			this.radioMode01 = new System.Windows.Forms.RadioButton();
			this.groupBox6 = new System.Windows.Forms.GroupBox();
			this.groupBox7 = new System.Windows.Forms.GroupBox();
			this.radioTimer0 = new System.Windows.Forms.RadioButton();
			this.radioCounter0 = new System.Windows.Forms.RadioButton();
			this.Gate0 = new System.Windows.Forms.CheckBox();
			this.groupBox8 = new System.Windows.Forms.GroupBox();
			this.radioMode30 = new System.Windows.Forms.RadioButton();
			this.radioMode20 = new System.Windows.Forms.RadioButton();
			this.radioMode10 = new System.Windows.Forms.RadioButton();
			this.radioMode00 = new System.Windows.Forms.RadioButton();
			this.label4 = new System.Windows.Forms.Label();
			this.regTmod = new System.Windows.Forms.TextBox();
			this.t0Overflow = new System.Windows.Forms.CheckBox();
			this.t0Running = new System.Windows.Forms.CheckBox();
			this.label2 = new System.Windows.Forms.Label();
			this.regTl0 = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.regTh0 = new System.Windows.Forms.TextBox();
			this.t1Overflow = new System.Windows.Forms.CheckBox();
			this.t1Running = new System.Windows.Forms.CheckBox();
			this.label5 = new System.Windows.Forms.Label();
			this.regTl1 = new System.Windows.Forms.TextBox();
			this.label6 = new System.Windows.Forms.Label();
			this.regTh1 = new System.Windows.Forms.TextBox();
			this.displayMode.SuspendLayout();
			this.controlRegs.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.groupBox4.SuspendLayout();
			this.groupBox5.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.groupBox9.SuspendLayout();
			this.groupBox6.SuspendLayout();
			this.groupBox7.SuspendLayout();
			this.groupBox8.SuspendLayout();
			this.SuspendLayout();
			// 
			// displayMode
			// 
			this.displayMode.Controls.AddRange(new System.Windows.Forms.Control[] {
																					  this.displayBin,
																					  this.displayDec,
																					  this.displayHex});
			this.displayMode.Location = new System.Drawing.Point(8, 8);
			this.displayMode.Name = "displayMode";
			this.displayMode.Size = new System.Drawing.Size(152, 40);
			this.displayMode.TabIndex = 16;
			this.displayMode.TabStop = false;
			this.displayMode.Text = "Display";
			// 
			// displayBin
			// 
			this.displayBin.Location = new System.Drawing.Point(104, 16);
			this.displayBin.Name = "displayBin";
			this.displayBin.Size = new System.Drawing.Size(40, 16);
			this.displayBin.TabIndex = 2;
			this.displayBin.TabStop = true;
			this.displayBin.Text = "Bin";
			// 
			// displayDec
			// 
			this.displayDec.Location = new System.Drawing.Point(56, 16);
			this.displayDec.Name = "displayDec";
			this.displayDec.Size = new System.Drawing.Size(48, 16);
			this.displayDec.TabIndex = 1;
			this.displayDec.TabStop = true;
			this.displayDec.Text = "Dec";
			// 
			// displayHex
			// 
			this.displayHex.Checked = true;
			this.displayHex.Location = new System.Drawing.Point(8, 16);
			this.displayHex.Name = "displayHex";
			this.displayHex.Size = new System.Drawing.Size(48, 16);
			this.displayHex.TabIndex = 0;
			this.displayHex.TabStop = true;
			this.displayHex.Text = "Hex";
			// 
			// controlRegs
			// 
			this.controlRegs.Controls.AddRange(new System.Windows.Forms.Control[] {
																					  this.regIe0,
																					  this.groupBox3,
																					  this.groupBox4,
																					  this.regIe1,
																					  this.label3,
																					  this.regTcon});
			this.controlRegs.Location = new System.Drawing.Point(8, 312);
			this.controlRegs.Name = "controlRegs";
			this.controlRegs.Size = new System.Drawing.Size(480, 144);
			this.controlRegs.TabIndex = 17;
			this.controlRegs.TabStop = false;
			this.controlRegs.Text = "TCON Flags";
			// 
			// regIe0
			// 
			this.regIe0.Location = new System.Drawing.Point(24, 48);
			this.regIe0.Name = "regIe0";
			this.regIe0.Size = new System.Drawing.Size(176, 16);
			this.regIe0.TabIndex = 16;
			this.regIe0.Text = "IE0 - External Interrupt 0 edge ";
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.regIt1False,
																					this.regIt1True});
			this.groupBox3.Location = new System.Drawing.Point(256, 72);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(208, 64);
			this.groupBox3.TabIndex = 15;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "IT1 - External Interrupt 1 Signal Type";
			// 
			// regIt1False
			// 
			this.regIt1False.Location = new System.Drawing.Point(8, 40);
			this.regIt1False.Name = "regIt1False";
			this.regIt1False.Size = new System.Drawing.Size(152, 16);
			this.regIt1False.TabIndex = 12;
			this.regIt1False.Text = "Triggered By Active Low";
			// 
			// regIt1True
			// 
			this.regIt1True.Checked = true;
			this.regIt1True.Location = new System.Drawing.Point(8, 16);
			this.regIt1True.Name = "regIt1True";
			this.regIt1True.Size = new System.Drawing.Size(160, 16);
			this.regIt1True.TabIndex = 11;
			this.regIt1True.TabStop = true;
			this.regIt1True.Text = "Triggered By Falling Edge";
			// 
			// groupBox4
			// 
			this.groupBox4.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.regIt0False,
																					this.regIt0True});
			this.groupBox4.Location = new System.Drawing.Point(16, 72);
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.Size = new System.Drawing.Size(208, 64);
			this.groupBox4.TabIndex = 14;
			this.groupBox4.TabStop = false;
			this.groupBox4.Text = "IT0 - External Interrupt 0 Signal Type";
			// 
			// regIt0False
			// 
			this.regIt0False.Location = new System.Drawing.Point(8, 40);
			this.regIt0False.Name = "regIt0False";
			this.regIt0False.Size = new System.Drawing.Size(152, 16);
			this.regIt0False.TabIndex = 12;
			this.regIt0False.Text = "Triggered By Active Low";
			// 
			// regIt0True
			// 
			this.regIt0True.Checked = true;
			this.regIt0True.Location = new System.Drawing.Point(8, 16);
			this.regIt0True.Name = "regIt0True";
			this.regIt0True.Size = new System.Drawing.Size(160, 16);
			this.regIt0True.TabIndex = 11;
			this.regIt0True.TabStop = true;
			this.regIt0True.Text = "Triggered By Falling Edge";
			// 
			// regIe1
			// 
			this.regIe1.Location = new System.Drawing.Point(264, 48);
			this.regIe1.Name = "regIe1";
			this.regIe1.Size = new System.Drawing.Size(176, 16);
			this.regIe1.TabIndex = 8;
			this.regIe1.Text = "IE1 - External Interrupt 1 edge ";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 16);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(40, 24);
			this.label3.TabIndex = 5;
			this.label3.Text = "TCON";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regTcon
			// 
			this.regTcon.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regTcon.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regTcon.Location = new System.Drawing.Point(56, 16);
			this.regTcon.MaxLength = 8;
			this.regTcon.Name = "regTcon";
			this.regTcon.Size = new System.Drawing.Size(64, 20);
			this.regTcon.TabIndex = 2;
			this.regTcon.Text = "00000000";
			this.regTcon.WordWrap = false;
			// 
			// groupBox5
			// 
			this.groupBox5.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.groupBox2,
																					this.groupBox6,
																					this.label4,
																					this.regTmod});
			this.groupBox5.Location = new System.Drawing.Point(8, 56);
			this.groupBox5.Name = "groupBox5";
			this.groupBox5.Size = new System.Drawing.Size(488, 192);
			this.groupBox5.TabIndex = 20;
			this.groupBox5.TabStop = false;
			this.groupBox5.Text = "TMOD Flags";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.groupBox1,
																					this.Gate1,
																					this.groupBox9});
			this.groupBox2.Location = new System.Drawing.Point(248, 48);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(232, 136);
			this.groupBox2.TabIndex = 20;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Timer/Counter 1";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.radioTimer1,
																					this.radioCounter1});
			this.groupBox1.Location = new System.Drawing.Point(8, 64);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(120, 64);
			this.groupBox1.TabIndex = 11;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Timer/Counter";
			// 
			// radioTimer1
			// 
			this.radioTimer1.Location = new System.Drawing.Point(8, 40);
			this.radioTimer1.Name = "radioTimer1";
			this.radioTimer1.Size = new System.Drawing.Size(104, 16);
			this.radioTimer1.TabIndex = 1;
			this.radioTimer1.Text = "Timer";
			// 
			// radioCounter1
			// 
			this.radioCounter1.Checked = true;
			this.radioCounter1.Location = new System.Drawing.Point(8, 16);
			this.radioCounter1.Name = "radioCounter1";
			this.radioCounter1.Size = new System.Drawing.Size(104, 16);
			this.radioCounter1.TabIndex = 0;
			this.radioCounter1.TabStop = true;
			this.radioCounter1.Text = "Counter";
			// 
			// Gate1
			// 
			this.Gate1.Location = new System.Drawing.Point(16, 24);
			this.Gate1.Name = "Gate1";
			this.Gate1.Size = new System.Drawing.Size(112, 16);
			this.Gate1.TabIndex = 10;
			this.Gate1.Text = "Gate";
			// 
			// groupBox9
			// 
			this.groupBox9.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.radioMode31,
																					this.radioMode21,
																					this.radioMode11,
																					this.radioMode01});
			this.groupBox9.Location = new System.Drawing.Point(136, 16);
			this.groupBox9.Name = "groupBox9";
			this.groupBox9.Size = new System.Drawing.Size(88, 112);
			this.groupBox9.TabIndex = 12;
			this.groupBox9.TabStop = false;
			this.groupBox9.Text = "Timer Mode";
			// 
			// radioMode31
			// 
			this.radioMode31.Location = new System.Drawing.Point(16, 88);
			this.radioMode31.Name = "radioMode31";
			this.radioMode31.Size = new System.Drawing.Size(64, 16);
			this.radioMode31.TabIndex = 3;
			this.radioMode31.Text = "Mode 3";
			// 
			// radioMode21
			// 
			this.radioMode21.Location = new System.Drawing.Point(16, 64);
			this.radioMode21.Name = "radioMode21";
			this.radioMode21.Size = new System.Drawing.Size(64, 16);
			this.radioMode21.TabIndex = 2;
			this.radioMode21.Text = "Mode 2";
			// 
			// radioMode11
			// 
			this.radioMode11.Location = new System.Drawing.Point(16, 40);
			this.radioMode11.Name = "radioMode11";
			this.radioMode11.Size = new System.Drawing.Size(64, 16);
			this.radioMode11.TabIndex = 1;
			this.radioMode11.Text = "Mode 1";
			// 
			// radioMode01
			// 
			this.radioMode01.Checked = true;
			this.radioMode01.Location = new System.Drawing.Point(16, 16);
			this.radioMode01.Name = "radioMode01";
			this.radioMode01.Size = new System.Drawing.Size(64, 16);
			this.radioMode01.TabIndex = 0;
			this.radioMode01.TabStop = true;
			this.radioMode01.Text = "Mode 0";
			// 
			// groupBox6
			// 
			this.groupBox6.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.groupBox7,
																					this.Gate0,
																					this.groupBox8});
			this.groupBox6.Location = new System.Drawing.Point(8, 48);
			this.groupBox6.Name = "groupBox6";
			this.groupBox6.Size = new System.Drawing.Size(232, 136);
			this.groupBox6.TabIndex = 10;
			this.groupBox6.TabStop = false;
			this.groupBox6.Text = "Timer/Counter 0";
			// 
			// groupBox7
			// 
			this.groupBox7.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.radioTimer0,
																					this.radioCounter0});
			this.groupBox7.Location = new System.Drawing.Point(8, 64);
			this.groupBox7.Name = "groupBox7";
			this.groupBox7.Size = new System.Drawing.Size(120, 64);
			this.groupBox7.TabIndex = 1;
			this.groupBox7.TabStop = false;
			this.groupBox7.Text = "Timer/Counter";
			// 
			// radioTimer0
			// 
			this.radioTimer0.Location = new System.Drawing.Point(8, 40);
			this.radioTimer0.Name = "radioTimer0";
			this.radioTimer0.Size = new System.Drawing.Size(104, 16);
			this.radioTimer0.TabIndex = 1;
			this.radioTimer0.Text = "Timer";
			// 
			// radioCounter0
			// 
			this.radioCounter0.Checked = true;
			this.radioCounter0.Location = new System.Drawing.Point(8, 16);
			this.radioCounter0.Name = "radioCounter0";
			this.radioCounter0.Size = new System.Drawing.Size(104, 16);
			this.radioCounter0.TabIndex = 0;
			this.radioCounter0.TabStop = true;
			this.radioCounter0.Text = "Counter";
			// 
			// Gate0
			// 
			this.Gate0.Location = new System.Drawing.Point(16, 24);
			this.Gate0.Name = "Gate0";
			this.Gate0.Size = new System.Drawing.Size(112, 16);
			this.Gate0.TabIndex = 0;
			this.Gate0.Text = "Gate";
			// 
			// groupBox8
			// 
			this.groupBox8.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.radioMode30,
																					this.radioMode20,
																					this.radioMode10,
																					this.radioMode00});
			this.groupBox8.Location = new System.Drawing.Point(136, 16);
			this.groupBox8.Name = "groupBox8";
			this.groupBox8.Size = new System.Drawing.Size(88, 112);
			this.groupBox8.TabIndex = 2;
			this.groupBox8.TabStop = false;
			this.groupBox8.Text = "Timer Mode";
			// 
			// radioMode30
			// 
			this.radioMode30.Location = new System.Drawing.Point(16, 88);
			this.radioMode30.Name = "radioMode30";
			this.radioMode30.Size = new System.Drawing.Size(64, 16);
			this.radioMode30.TabIndex = 3;
			this.radioMode30.Text = "Mode 3";
			// 
			// radioMode20
			// 
			this.radioMode20.Location = new System.Drawing.Point(16, 64);
			this.radioMode20.Name = "radioMode20";
			this.radioMode20.Size = new System.Drawing.Size(64, 16);
			this.radioMode20.TabIndex = 2;
			this.radioMode20.Text = "Mode 2";
			// 
			// radioMode10
			// 
			this.radioMode10.Location = new System.Drawing.Point(16, 40);
			this.radioMode10.Name = "radioMode10";
			this.radioMode10.Size = new System.Drawing.Size(64, 16);
			this.radioMode10.TabIndex = 1;
			this.radioMode10.Text = "Mode 1";
			// 
			// radioMode00
			// 
			this.radioMode00.Checked = true;
			this.radioMode00.Location = new System.Drawing.Point(16, 16);
			this.radioMode00.Name = "radioMode00";
			this.radioMode00.Size = new System.Drawing.Size(64, 16);
			this.radioMode00.TabIndex = 0;
			this.radioMode00.TabStop = true;
			this.radioMode00.Text = "Mode 0";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 16);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(40, 24);
			this.label4.TabIndex = 9;
			this.label4.Text = "TMOD";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regTmod
			// 
			this.regTmod.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regTmod.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regTmod.Location = new System.Drawing.Point(56, 16);
			this.regTmod.MaxLength = 8;
			this.regTmod.Name = "regTmod";
			this.regTmod.Size = new System.Drawing.Size(64, 20);
			this.regTmod.TabIndex = 8;
			this.regTmod.Text = "00000000";
			this.regTmod.WordWrap = false;
			// 
			// t0Overflow
			// 
			this.t0Overflow.Location = new System.Drawing.Point(128, 280);
			this.t0Overflow.Name = "t0Overflow";
			this.t0Overflow.Size = new System.Drawing.Size(104, 16);
			this.t0Overflow.TabIndex = 26;
			this.t0Overflow.Text = "TF0 - Overflow Flag";
			// 
			// t0Running
			// 
			this.t0Running.Location = new System.Drawing.Point(128, 256);
			this.t0Running.Name = "t0Running";
			this.t0Running.Size = new System.Drawing.Size(104, 16);
			this.t0Running.TabIndex = 25;
			this.t0Running.Text = "TR0 - Running";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 280);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(32, 24);
			this.label2.TabIndex = 24;
			this.label2.Text = "TL0";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regTl0
			// 
			this.regTl0.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regTl0.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regTl0.Location = new System.Drawing.Point(56, 280);
			this.regTl0.MaxLength = 8;
			this.regTl0.Name = "regTl0";
			this.regTl0.Size = new System.Drawing.Size(64, 20);
			this.regTl0.TabIndex = 23;
			this.regTl0.Text = "00000000";
			this.regTl0.WordWrap = false;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 256);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(32, 24);
			this.label1.TabIndex = 22;
			this.label1.Text = "TH0";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regTh0
			// 
			this.regTh0.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regTh0.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regTh0.Location = new System.Drawing.Point(56, 256);
			this.regTh0.MaxLength = 8;
			this.regTh0.Name = "regTh0";
			this.regTh0.Size = new System.Drawing.Size(64, 20);
			this.regTh0.TabIndex = 21;
			this.regTh0.Text = "00000000";
			this.regTh0.WordWrap = false;
			// 
			// t1Overflow
			// 
			this.t1Overflow.Location = new System.Drawing.Point(376, 280);
			this.t1Overflow.Name = "t1Overflow";
			this.t1Overflow.Size = new System.Drawing.Size(104, 16);
			this.t1Overflow.TabIndex = 32;
			this.t1Overflow.Text = "TF1 - Overflow Flag";
			// 
			// t1Running
			// 
			this.t1Running.Location = new System.Drawing.Point(376, 256);
			this.t1Running.Name = "t1Running";
			this.t1Running.Size = new System.Drawing.Size(104, 16);
			this.t1Running.TabIndex = 31;
			this.t1Running.Text = "TR1 - Running";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(264, 280);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(32, 24);
			this.label5.TabIndex = 30;
			this.label5.Text = "TL1";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regTl1
			// 
			this.regTl1.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regTl1.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regTl1.Location = new System.Drawing.Point(304, 280);
			this.regTl1.MaxLength = 8;
			this.regTl1.Name = "regTl1";
			this.regTl1.Size = new System.Drawing.Size(64, 20);
			this.regTl1.TabIndex = 29;
			this.regTl1.Text = "00000000";
			this.regTl1.WordWrap = false;
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(264, 256);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(32, 24);
			this.label6.TabIndex = 28;
			this.label6.Text = "TH1";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// regTh1
			// 
			this.regTh1.CharacterCasing = System.Windows.Forms.CharacterCasing.Upper;
			this.regTh1.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.regTh1.Location = new System.Drawing.Point(304, 256);
			this.regTh1.MaxLength = 8;
			this.regTh1.Name = "regTh1";
			this.regTh1.Size = new System.Drawing.Size(64, 20);
			this.regTh1.TabIndex = 27;
			this.regTh1.Text = "00000000";
			this.regTh1.WordWrap = false;
			// 
			// TimerCounterRegistersForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(506, 466);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.t1Overflow,
																		  this.t1Running,
																		  this.label5,
																		  this.regTl1,
																		  this.label6,
																		  this.regTh1,
																		  this.t0Overflow,
																		  this.t0Running,
																		  this.label2,
																		  this.regTl0,
																		  this.label1,
																		  this.regTh0,
																		  this.groupBox5,
																		  this.controlRegs,
																		  this.displayMode});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.Name = "TimerCounterRegistersForm";
			this.Text = "Timer/Counter Registers";
			this.TopMost = true;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.TimerCounterRegistersForm_Closing);
			this.displayMode.ResumeLayout(false);
			this.controlRegs.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.groupBox4.ResumeLayout(false);
			this.groupBox5.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.groupBox9.ResumeLayout(false);
			this.groupBox6.ResumeLayout(false);
			this.groupBox7.ResumeLayout(false);
			this.groupBox8.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
	}
}
